/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawersStandard
extends BlockEntityDrawers {
    public BlockEntityDrawersStandard(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public static BlockEntityDrawersStandard createEntity(int slotCount, BlockPos pos, BlockState state) {
        return switch (slotCount) {
            case 1 -> new Slot1(pos, state);
            case 2 -> new Slot2(pos, state);
            case 4 -> new Slot4(pos, state);
            default -> null;
        };
    }

    public static class Slot1
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(1);

        public Slot1(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_1.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(2);

        public Slot2(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_2.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot4
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(4);

        public Slot4(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_4.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private final int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        @Override
        protected int getStackCapacity() {
            return BlockEntityDrawersStandard.this.upgrades().getStorageMultiplier() * BlockEntityDrawersStandard.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
            NeoForge.EVENT_BUS.post((Event)event);
            if (BlockEntityDrawersStandard.this.getLevel() != null && !BlockEntityDrawersStandard.this.getLevel().isClientSide) {
                BlockEntityDrawersStandard.this.setChanged();
                BlockEntityDrawersStandard.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (BlockEntityDrawersStandard.this.getLevel() != null && !BlockEntityDrawersStandard.this.getLevel().isClientSide) {
                BlockEntityDrawersStandard.this.syncClientCount(this.slot, this.getStoredItemCount());
                BlockEntityDrawersStandard.this.setChanged();
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        @NotNull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersStandard.this.isGroupValid();
        }

        @Override
        public <T> T getCapability(@NotNull BlockCapability<T, Void> capability) {
            if (BlockEntityDrawersStandard.this.level == null) {
                return null;
            }
            return (T)BlockEntityDrawersStandard.this.level.getCapability(capability, BlockEntityDrawersStandard.this.getBlockPos(), BlockEntityDrawersStandard.this.getBlockState(), (BlockEntity)BlockEntityDrawersStandard.this, null);
        }
    }
}

