/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ControllerData
extends BlockEntityDataShim {
    private BlockPos controllerCoord;

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        this.controllerCoord = null;
        if (tag.contains("Controller", 10)) {
            CompoundTag ctag = tag.getCompound("Controller");
            this.controllerCoord = new BlockPos(ctag.getInt("x"), ctag.getInt("y"), ctag.getInt("z"));
        }
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.controllerCoord != null) {
            CompoundTag ctag = new CompoundTag();
            ctag.putInt("x", this.controllerCoord.getX());
            ctag.putInt("y", this.controllerCoord.getY());
            ctag.putInt("z", this.controllerCoord.getZ());
            tag.put("Controller", (Tag)ctag);
        }
        return tag;
    }

    public BlockPos getCoord() {
        return this.controllerCoord;
    }

    public BlockEntityController getController(BlockEntity host) {
        if (this.controllerCoord == null) {
            return null;
        }
        if (host.getLevel() == null) {
            return null;
        }
        BlockEntity blockEntity = host.getLevel().getBlockEntity(this.controllerCoord);
        if (!(blockEntity instanceof BlockEntityController)) {
            this.controllerCoord = null;
            host.setChanged();
            return null;
        }
        return (BlockEntityController)blockEntity;
    }

    public boolean bindCoord(BlockPos pos) {
        if (this.controllerCoord == null || !this.controllerCoord.equals((Object)pos)) {
            this.controllerCoord = pos;
            return true;
        }
        return false;
    }
}

