/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public abstract class StandardDrawerGroup
extends BlockEntityDataShim
implements IDrawerGroup {
    private final DrawerData[] slots;
    private final int[] order;

    public StandardDrawerGroup(int slotCount) {
        this.slots = new DrawerData[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = this.createDrawer(i);
        }
        this.order = new int[slotCount];
        this.syncSlots();
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED;
        }
        return this.slots[slot];
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        if (!tag.contains("Drawers")) {
            return;
        }
        ListTag itemList = tag.getList("Drawers", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            if (i >= this.slots.length) continue;
            this.slots[i].deserializeNBT(provider, itemList.getCompound(i));
        }
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.slots == null) {
            return tag;
        }
        ListTag itemList = new ListTag();
        for (DrawerData slot : this.slots) {
            itemList.add((Object)slot.serializeNBT(provider));
        }
        tag.put("Drawers", (Tag)itemList);
        return tag;
    }

    @NotNull
    protected abstract DrawerData createDrawer(int var1);

    public void syncAttributes() {
        for (DrawerData drawer : this.slots) {
            drawer.syncAttributes();
        }
    }

    public void syncSlots() {
        IDrawer drawer;
        int i;
        int index = 0;
        for (i = 0; i < this.slots.length; ++i) {
            drawer = this.getDrawer(i);
            if (drawer.isEmpty()) continue;
            this.order[index++] = i;
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (!drawer.isEnabled() || !drawer.isEmpty()) continue;
                this.order[index++] = i;
            }
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (drawer.isEnabled()) continue;
                this.order[index++] = i;
            }
        }
    }

    public static class DrawerData
    implements IDrawer,
    INBTSerializable<CompoundTag> {
        IDrawerAttributes cachedAttrs;
        StandardDrawerGroup group;
        @NotNull
        private ItemStack protoStack;
        private int count;
        private ItemStackMatcher matcher;

        public DrawerData(StandardDrawerGroup group) {
            this.group = group;
            this.protoStack = ItemStack.EMPTY;
            this.matcher = ItemStackMatcher.EMPTY;
        }

        @NotNull
        IDrawerAttributes getAttributes() {
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            this.cachedAttrs = (IDrawerAttributes)this.group.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY);
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            return EmptyDrawerAttributes.EMPTY;
        }

        @Override
        @NotNull
        public ItemStack getStoredItemPrototype() {
            return this.protoStack;
        }

        @Override
        @NotNull
        public IDrawer setStoredItem(@NotNull ItemStack itemPrototype) {
            return this.setStoredItem(itemPrototype, true);
        }

        protected IDrawer setStoredItem(@NotNull ItemStack itemPrototype, boolean notify) {
            if (ItemStackHelper.isStackEncoded(itemPrototype)) {
                itemPrototype = ItemStackHelper.decodeItemStackPrototype(itemPrototype);
            }
            if (this.matcher.matches(itemPrototype)) {
                return this;
            }
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).isEmpty()) {
                this.reset(notify);
                return this;
            }
            this.protoStack = itemPrototype;
            this.protoStack.setCount(1);
            this.count = 0;
            this.matcher = new ItemStackMatcher(this.protoStack);
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
            return this;
        }

        protected IDrawer setStoredItemRaw(@NotNull ItemStack itemPrototype) {
            this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
            this.protoStack.setCount(1);
            this.count = 0;
            this.matcher = new ItemStackMatcher(this.protoStack);
            return this;
        }

        @Override
        public int getStoredItemCount() {
            if (this.protoStack.isEmpty()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.count;
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.setStoredItemCount(amount, true);
        }

        protected void setStoredItemCount(int amount, boolean notify) {
            if (this.protoStack.isEmpty() || this.count == amount) {
                return;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return;
            }
            this.count = Math.min(amount, this.getMaxCapacity());
            this.count = Math.max(this.count, 0);
            if (this.count == 0 && !attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset(notify);
            } else if (notify) {
                this.onAmountChanged();
            }
        }

        protected void setStoredItemCountRaw(int amount) {
            this.count = amount;
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.adjustStoredItemCount(amount, true);
        }

        protected int adjustStoredItemCount(int amount, boolean notify) {
            if (this.protoStack.isEmpty() || amount == 0) {
                return Math.abs(amount);
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (amount > 0) {
                if (attrs.isUnlimitedVending()) {
                    return 0;
                }
                int originalCount = this.count;
                this.count = Math.min(this.count + amount, this.getMaxCapacity());
                if (this.count != originalCount && notify) {
                    this.onAmountChanged();
                }
                if (attrs.isVoid()) {
                    return 0;
                }
                return amount - (this.count - originalCount);
            }
            if (attrs.isUnlimitedVending()) {
                return 0;
            }
            int originalCount = this.count;
            this.setStoredItemCount(originalCount + amount, notify);
            return -amount - (originalCount - this.count);
        }

        @Override
        public int getMaxCapacity(@NotNull ItemStack itemPrototype) {
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedStorage() || attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            if (itemPrototype.isEmpty()) {
                return 64 * this.getStackCapacity();
            }
            return itemPrototype.getItem().getMaxStackSize(itemPrototype) * this.getStackCapacity();
        }

        @Override
        public int getAcceptingMaxCapacity(@NotNull ItemStack itemPrototype) {
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            if (this.protoStack.isEmpty()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            if (this.protoStack.isEmpty()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending() || attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public boolean canItemBeStored(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            IDrawerAttributes attrs = this.getAttributes();
            if (this.protoStack.isEmpty() && !attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return true;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean canItemBeExtracted(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.protoStack.isEmpty()) {
                return false;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean isEmpty() {
            return this.protoStack.isEmpty();
        }

        protected void reset(boolean notify) {
            this.protoStack = ItemStack.EMPTY;
            this.count = 0;
            this.matcher = ItemStackMatcher.EMPTY;
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            if (this.protoStack.isEmpty()) {
                return tag;
            }
            CompoundTag item = new CompoundTag();
            item = (CompoundTag)this.protoStack.save(provider, (Tag)item);
            tag.put("Item", (Tag)item);
            tag.putInt("Count", this.count);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            ItemStack tagItem = ItemStack.EMPTY;
            int tagCount = 0;
            if (nbt.contains("Item")) {
                tagItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("Item"));
            }
            if (nbt.contains("Count")) {
                tagCount = nbt.getInt("Count");
            }
            this.setStoredItemRaw(tagItem);
            this.setStoredItemCountRaw(tagCount);
        }

        public void syncAttributes() {
            if (!this.protoStack.isEmpty()) {
                this.matcher = new ItemStackMatcher(this.protoStack);
            }
        }

        protected int getStackCapacity() {
            return 0;
        }

        protected void onItemChanged() {
        }

        protected void onAmountChanged() {
        }
    }
}

