/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class UpgradeData
extends BlockEntityDataShim {
    protected final ItemStack[] upgrades;
    private int storageMultiplier;
    private EnumUpgradeRedstone redstoneType;
    private boolean hasOneStack;
    private boolean hasVoid;
    private boolean hasUnlimited;
    private boolean hasVending;
    private boolean hasConversion;
    private boolean hasIllumination;
    private boolean hasFillLevel;
    private IDrawerAttributesModifiable attrs;

    public UpgradeData(int slotCount) {
        this.upgrades = new ItemStack[slotCount];
        Arrays.fill(this.upgrades, ItemStack.EMPTY);
        this.syncStorageMultiplier();
    }

    public void setDrawerAttributes(IDrawerAttributesModifiable attrs) {
        this.attrs = attrs;
        this.syncUpgrades();
    }

    public int getSlotCount() {
        return this.upgrades.length;
    }

    @NotNull
    public ItemStack getUpgrade(int slot) {
        slot = Mth.clamp((int)slot, (int)0, (int)(this.upgrades.length - 1));
        return this.upgrades[slot];
    }

    public boolean hasEmptySlot() {
        return this.getNextUpgradeSlot() != -1;
    }

    public boolean addUpgrade(@NotNull ItemStack upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        return true;
    }

    public boolean setUpgrade(int slot, @NotNull ItemStack upgrade) {
        ItemStack prevUpgrade;
        slot = Mth.clamp((int)slot, (int)0, (int)(this.upgrades.length - 1));
        if (!upgrade.isEmpty()) {
            upgrade = upgrade.copy();
            upgrade.setCount(1);
        }
        if (!(prevUpgrade = this.upgrades[slot]).isEmpty() && !this.canRemoveUpgrade(slot)) {
            return false;
        }
        this.upgrades[slot] = ItemStack.EMPTY;
        this.syncStorageMultiplier();
        if (!upgrade.isEmpty() && !this.canAddUpgrade(upgrade)) {
            this.upgrades[slot] = prevUpgrade;
            this.syncStorageMultiplier();
            return false;
        }
        this.upgrades[slot] = upgrade;
        this.syncUpgrades();
        this.onUpgradeChanged(prevUpgrade, upgrade);
        return true;
    }

    public boolean canAddUpgrade(@NotNull ItemStack upgrade) {
        if (upgrade.isEmpty()) {
            return false;
        }
        ItemStack[] itemStackArray = upgrade.getItem();
        if (!(itemStackArray instanceof ItemUpgrade)) {
            return false;
        }
        ItemUpgrade candidate = (ItemUpgrade)itemStackArray;
        if (candidate.getAllowMultiple()) {
            return true;
        }
        for (ItemStack stack : this.upgrades) {
            Item item;
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof ItemUpgrade)) continue;
            ItemUpgrade reference = (ItemUpgrade)item;
            if (candidate.getUpgradeGroup() != reference.getUpgradeGroup()) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveUpgrade(int slot) {
        return !this.upgrades[slot = Mth.clamp((int)slot, (int)0, (int)(this.upgrades.length - 1))].isEmpty();
    }

    public boolean canSwapUpgrade(int slot, @Nonnull ItemStack add) {
        return this.canAddUpgrade(add) && this.canRemoveUpgrade(slot);
    }

    public int getStorageMultiplier() {
        return this.storageMultiplier;
    }

    public EnumUpgradeRedstone getRedstoneType() {
        return this.redstoneType;
    }

    public boolean hasOneStackUpgrade() {
        return this.hasOneStack;
    }

    public boolean hasUnlimitedUpgrade() {
        return this.hasUnlimited;
    }

    public boolean hasVendingUpgrade() {
        return this.hasVending;
    }

    public boolean hasConversionUpgrade() {
        return this.hasConversion;
    }

    public boolean hasIlluminationUpgrade() {
        return this.hasIllumination;
    }

    private int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (!this.upgrades[i].isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private void syncUpgrades() {
        if (this.attrs == null) {
            return;
        }
        this.syncStorageMultiplier();
        this.syncRedstoneLevel();
        this.hasOneStack = false;
        this.hasVoid = false;
        this.hasUnlimited = false;
        this.hasVending = false;
        this.hasConversion = false;
        this.hasIllumination = false;
        this.hasFillLevel = false;
        for (ItemStack stack : this.upgrades) {
            Item item = stack.getItem();
            if (item == ModItems.ONE_STACK_UPGRADE.get()) {
                this.hasOneStack = true;
                continue;
            }
            if (item == ModItems.VOID_UPGRADE.get()) {
                this.hasVoid = true;
                continue;
            }
            if (item == ModItems.CREATIVE_STORAGE_UPGRADE.get()) {
                this.hasUnlimited = true;
                continue;
            }
            if (item == ModItems.CREATIVE_VENDING_UPGRADE.get()) {
                this.hasVending = true;
                continue;
            }
            if (item == ModItems.ILLUMINATION_UPGRADE.get()) {
                this.hasIllumination = true;
                continue;
            }
            if (item != ModItems.FILL_LEVEL_UPGRADE.get()) continue;
            this.hasFillLevel = true;
        }
        this.attrs.setIsVoid(this.hasVoid);
        this.attrs.setHasFillLevel(this.hasFillLevel);
        this.attrs.setIsDictConvertible(this.hasConversion);
        this.attrs.setIsUnlimitedStorage(this.hasUnlimited);
        this.attrs.setIsUnlimitedVending(this.hasVending);
    }

    private void syncStorageMultiplier() {
        this.storageMultiplier = 0;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.getItem() instanceof ItemUpgradeStorage)) continue;
            int level = ((ItemUpgradeStorage)stack.getItem()).level.getLevel();
            this.storageMultiplier += CommonConfig.UPGRADES.getLevelMult(level);
        }
        if (this.storageMultiplier == 0) {
            this.storageMultiplier = CommonConfig.UPGRADES.getLevelMult(0);
        }
    }

    private void syncRedstoneLevel() {
        this.redstoneType = null;
        for (ItemStack stack : this.upgrades) {
            if (!(stack.getItem() instanceof ItemUpgradeRedstone)) continue;
            this.redstoneType = ((ItemUpgradeRedstone)stack.getItem()).type;
            break;
        }
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        Arrays.fill(this.upgrades, ItemStack.EMPTY);
        if (!tag.contains("Upgrades")) {
            return;
        }
        ListTag tagList = tag.getList("Upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag upgradeTag = tagList.getCompound(i);
            byte slot = upgradeTag.getByte("Slot");
            this.upgrades[slot] = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)upgradeTag);
        }
        this.syncUpgrades();
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag tag) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i].isEmpty()) continue;
            CompoundTag upgradeTag = (CompoundTag)this.upgrades[i].save(provider, (Tag)new CompoundTag());
            upgradeTag.putByte("Slot", (byte)i);
            tagList.add((Object)upgradeTag);
        }
        tag.put("Upgrades", (Tag)tagList);
        return tag;
    }

    protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
    }
}

