/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityItemRepository;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class DrawerItemHandler
implements IItemHandler {
    private final IDrawerGroup group;

    public DrawerItemHandler(IDrawerGroup group) {
        this.group = group;
    }

    public int getSlots() {
        if (!this.group.isGroupValid()) {
            return 0;
        }
        return this.group.getDrawerCount() + 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        IDrawer drawer;
        if (!this.group.isGroupValid()) {
            return ItemStack.EMPTY;
        }
        if (this.slotIsVirtual(slot)) {
            return ItemStack.EMPTY;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = drawer.getStoredItemPrototype().copy();
        stack.setCount(drawer.getStoredItemCount());
        return stack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        IDrawer prevDrawer;
        IDrawer drawer;
        int prevSlot;
        if (!this.group.isGroupValid()) {
            return stack;
        }
        if (this.slotIsVirtual(slot)) {
            return this.insertItemFullScan(stack, simulate);
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        int orderedSlot = --slot >= 0 && slot < order.length ? order[slot] : -1;
        int n = prevSlot = slot >= 1 && slot < order.length ? order[slot - 1] : -1;
        if (orderedSlot > 0 && (drawer = this.group.getDrawer(orderedSlot)).isEnabled() && drawer.isEmpty() && (!(prevDrawer = this.group.getDrawer(prevSlot)).isEnabled() || !prevDrawer.isEmpty())) {
            return this.insertItemFullScan(stack, simulate);
        }
        return this.insertItemInternal(orderedSlot, stack, simulate);
    }

    @NotNull
    private ItemStack insertItemFullScan(@NotNull ItemStack stack, boolean simulate) {
        IItemRepository itemRepo = this.group.getCapability(CapabilityItemRepository.ITEM_REPOSITORY_CAPABILITY);
        if (itemRepo != null) {
            return itemRepo.insertItem(stack, simulate);
        }
        for (int i = 0; i < this.group.getDrawerCount() && !(stack = this.insertItemInternal(i, stack, simulate)).isEmpty(); ++i) {
        }
        return stack;
    }

    @NotNull
    private ItemStack insertItemInternal(int slot, @NotNull ItemStack stack, boolean simulate) {
        int remainder;
        IDrawer drawer = this.group.getDrawer(slot);
        if (!drawer.canItemBeStored(stack)) {
            return stack;
        }
        if (drawer.isEmpty() && !simulate) {
            drawer = drawer.setStoredItem(stack);
        }
        boolean empty = drawer.isEmpty();
        int n = simulate ? Math.max(stack.getCount() - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (remainder = drawer.adjustStoredItemCount(stack.getCount()));
        if (remainder == stack.getCount()) {
            return stack;
        }
        if (remainder == 0) {
            return ItemStack.EMPTY;
        }
        return this.stackResult(stack, remainder);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IDrawer drawer;
        if (!this.group.isGroupValid()) {
            return ItemStack.EMPTY;
        }
        if (this.slotIsVirtual(slot)) {
            return ItemStack.EMPTY;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.isEmpty() || drawer.getStoredItemCount() == 0) {
            return ItemStack.EMPTY;
        }
        @NotNull ItemStack prototype = drawer.getStoredItemPrototype();
        int remaining = simulate ? Math.max(amount - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-amount);
        return this.stackResult(prototype, amount - remaining);
    }

    public int getSlotLimit(int slot) {
        IDrawer drawer;
        if (!this.group.isGroupValid()) {
            return 0;
        }
        if (this.slotIsVirtual(slot)) {
            return Integer.MAX_VALUE;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled()) {
            return 0;
        }
        if (drawer.isEmpty()) {
            return drawer.getMaxCapacity(ItemStack.EMPTY);
        }
        return drawer.getMaxCapacity();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    private boolean slotIsVirtual(int slot) {
        return slot == 0;
    }

    private ItemStack stackResult(@NotNull ItemStack stack, int amount) {
        ItemStack result = stack.copy();
        result.setCount(amount);
        return result;
    }
}

