/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.ProxyBuilderModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public final class BasicDrawerModel {
    private static final Map<Direction, BakedModel> lockOverlaysFull = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> lockOverlaysHalf = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> voidOverlaysFull = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> voidOverlaysHalf = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> shroudOverlaysFull = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> shroudOverlaysHalf = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator1Full = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator1Half = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator2Full = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator2Half = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator4Full = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator4Half = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicatorComp = new HashMap<Direction, BakedModel>();
    private static boolean geometryDataLoaded = false;

    public static class Model
    extends ProxyBuilderModel {
        Direction side;
        Map<Direction, BakedModel> overlays;

        public Model(BakedModel parent, Map<Direction, BakedModel> overlays, Direction side) {
            super(parent);
            this.overlays = overlays;
            this.side = side;
        }

        @Override
        protected BakedModel buildModel(BlockState state, BakedModel parent) {
            return new MergedModel(parent, this.overlays.get(this.side));
        }
    }

    public static abstract class Model2
    implements IDynamicBakedModel {
        protected final BakedModel mainModel;
        protected final Map<Direction, BakedModel> lockOverlay;
        protected final Map<Direction, BakedModel> voidOverlay;
        protected final Map<Direction, BakedModel> shroudOverlay;
        protected final Map<Direction, BakedModel> indicator1Overlay;
        protected final Map<Direction, BakedModel> indicator2Overlay;
        protected final Map<Direction, BakedModel> indicator4Overlay;
        protected final Map<Direction, BakedModel> indicatorCompOverlay;

        private Model2(BakedModel mainModel, Map<Direction, BakedModel> lockOverlay, Map<Direction, BakedModel> voidOverlay, Map<Direction, BakedModel> shroudOverlay, Map<Direction, BakedModel> indicator1Overlay, Map<Direction, BakedModel> indicator2Overlay, Map<Direction, BakedModel> indicator4Overlay) {
            this.mainModel = mainModel;
            this.lockOverlay = lockOverlay;
            this.voidOverlay = voidOverlay;
            this.shroudOverlay = shroudOverlay;
            this.indicator1Overlay = indicator1Overlay;
            this.indicator2Overlay = indicator2Overlay;
            this.indicator4Overlay = indicator4Overlay;
            this.indicatorCompOverlay = indicatorComp;
        }

        public boolean usesBlockLight() {
            return this.mainModel.usesBlockLight();
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType type) {
            BakedModel model;
            List mainQuads;
            if (state != null) {
                ChunkRenderTypeSet renderTypes = this.mainModel.getRenderTypes(state, rand, extraData);
                mainQuads = type == null || renderTypes.contains(type) ? this.mainModel.getQuads(state, side, rand, extraData, type) : Collections.emptyList();
            } else {
                return this.mainModel.getQuads(null, side, rand, extraData, type);
            }
            if (!extraData.has(BlockEntityDrawers.ATTRIBUTES)) {
                return mainQuads;
            }
            if (type != null && type != RenderType.cutoutMipped()) {
                return mainQuads;
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(mainQuads);
            IDrawerAttributes attr = (IDrawerAttributes)extraData.get(BlockEntityDrawers.ATTRIBUTES);
            Direction dir = (Direction)state.getValue((Property)BlockDrawers.FACING);
            if ((attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED)) && (model = this.lockOverlay.get(dir)) != null) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
            if (attr.isVoid() && (model = this.voidOverlay.get(dir)) != null) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
            if (attr.isConcealed() && (model = this.shroudOverlay.get(dir)) != null) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
            if (attr.hasFillLevel()) {
                Block block = state.getBlock();
                if (block instanceof BlockCompDrawers) {
                    BakedModel model2 = this.indicatorCompOverlay.get(dir);
                    if (model2 != null) {
                        quads.addAll(model2.getQuads(state, side, rand, extraData, type));
                    }
                } else if (block instanceof BlockDrawers) {
                    BakedModel model3;
                    int count = ((BlockDrawers)block).getDrawerCount();
                    if (count == 1) {
                        BakedModel model4 = this.indicator1Overlay.get(dir);
                        if (model4 != null) {
                            quads.addAll(model4.getQuads(state, side, rand, extraData, type));
                        }
                    } else if (count == 2) {
                        BakedModel model5 = this.indicator2Overlay.get(dir);
                        if (model5 != null) {
                            quads.addAll(model5.getQuads(state, side, rand, extraData, type));
                        }
                    } else if (count == 4 && (model3 = this.indicator4Overlay.get(dir)) != null) {
                        quads.addAll(model3.getQuads(state, side, rand, extraData, type));
                    }
                }
            }
            return quads;
        }

        public boolean useAmbientOcclusion() {
            return this.mainModel.useAmbientOcclusion();
        }

        public boolean isGui3d() {
            return this.mainModel.isGui3d();
        }

        public boolean isCustomRenderer() {
            return this.mainModel.isCustomRenderer();
        }

        @NotNull
        public TextureAtlasSprite getParticleIcon() {
            return this.mainModel.getParticleIcon();
        }

        @NotNull
        public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
            return this.mainModel.getParticleIcon(data);
        }

        @NotNull
        public ItemOverrides getOverrides() {
            return this.mainModel.getOverrides();
        }

        @NotNull
        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutoutMipped()}), this.mainModel.getRenderTypes(state, rand, data)});
        }

        @NotNull
        public List<RenderType> getRenderTypes(@NotNull ItemStack itemStack, boolean fabulous) {
            return Collections.emptyList();
        }

        @NotNull
        public List<BakedModel> getRenderPasses(@NotNull ItemStack itemStack, boolean fabulous) {
            return this.mainModel.getRenderPasses(itemStack, fabulous);
        }

        public static class HalfModel
        extends Model2 {
            HalfModel(BakedModel mainModel) {
                super(mainModel, lockOverlaysHalf, voidOverlaysHalf, shroudOverlaysHalf, indicator1Half, indicator2Half, indicator4Half);
            }
        }

        public static class FullModel
        extends Model2 {
            FullModel(BakedModel mainModel) {
                super(mainModel, lockOverlaysFull, voidOverlaysFull, shroudOverlaysFull, indicator1Full, indicator2Full, indicator4Full);
            }
        }
    }

    public static class MergedModel
    implements IDynamicBakedModel {
        protected final BakedModel mainModel;
        protected final BakedModel[] models;

        public MergedModel(BakedModel mainModel, BakedModel ... models) {
            this.mainModel = mainModel;
            this.models = models;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType type) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.mainModel.getQuads(state, side, rand, data, type));
            for (BakedModel model : this.models) {
                quads.addAll(model.getQuads(state, side, rand, data, type));
            }
            return quads;
        }

        public boolean useAmbientOcclusion() {
            return this.mainModel.useAmbientOcclusion();
        }

        public boolean isGui3d() {
            return this.mainModel.isGui3d();
        }

        public boolean usesBlockLight() {
            return this.mainModel.usesBlockLight();
        }

        public boolean isCustomRenderer() {
            return this.mainModel.isCustomRenderer();
        }

        @NotNull
        public TextureAtlasSprite getParticleIcon() {
            return this.mainModel.getParticleIcon();
        }

        @NotNull
        public ItemOverrides getOverrides() {
            return this.mainModel.getOverrides();
        }
    }

    @EventBusSubscriber(modid="storagedrawers", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Register {
        @SubscribeEvent
        public static void registerTextures(TextureAtlasStitchedEvent event) {
            if (!ModBlocks.OAK_FULL_DRAWERS_1.isBound()) {
                StorageDrawers.log.warn("Block objects not set in TextureStitchEvent.  Is your mod environment broken?");
                return;
            }
            Register.loadGeometryData();
        }

        private static void loadGeometryData() {
            if (geometryDataLoaded) {
                return;
            }
            geometryDataLoaded = true;
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/full_drawers_icon_area_1.json"), StorageDrawers.rl("models/block/geometry/full_drawers_count_area_1.json"), StorageDrawers.rl("models/block/geometry/full_drawers_ind_area_1.json"), StorageDrawers.rl("models/block/geometry/full_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/full_drawers_icon_area_2.json"), StorageDrawers.rl("models/block/geometry/full_drawers_count_area_2.json"), StorageDrawers.rl("models/block/geometry/full_drawers_ind_area_2.json"), StorageDrawers.rl("models/block/geometry/full_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/full_drawers_icon_area_4.json"), StorageDrawers.rl("models/block/geometry/full_drawers_count_area_4.json"), StorageDrawers.rl("models/block/geometry/full_drawers_ind_area_4.json"), StorageDrawers.rl("models/block/geometry/full_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/half_drawers_icon_area_1.json"), StorageDrawers.rl("models/block/geometry/half_drawers_count_area_1.json"), StorageDrawers.rl("models/block/geometry/half_drawers_ind_area_1.json"), StorageDrawers.rl("models/block/geometry/half_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/half_drawers_icon_area_2.json"), StorageDrawers.rl("models/block/geometry/half_drawers_count_area_2.json"), StorageDrawers.rl("models/block/geometry/half_drawers_ind_area_2.json"), StorageDrawers.rl("models/block/geometry/half_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/half_drawers_icon_area_4.json"), StorageDrawers.rl("models/block/geometry/half_drawers_count_area_4.json"), StorageDrawers.rl("models/block/geometry/half_drawers_ind_area_4.json"), StorageDrawers.rl("models/block/geometry/half_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/comp_drawers_icon_area_3.json"), StorageDrawers.rl("models/block/geometry/comp_drawers_count_area_3.json"), StorageDrawers.rl("models/block/geometry/comp_drawers_ind_area_3.json"), StorageDrawers.rl("models/block/geometry/comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfType(BlockCompDrawers.class).toArray(BlockDrawers[]::new));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static BlockModel getBlockModel(ResourceLocation location) {
            Resource iresource = null;
            InputStreamReader reader = null;
            try {
                iresource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(location);
                reader = new InputStreamReader(iresource.open(), StandardCharsets.UTF_8);
                BlockModel blockModel = BlockModel.fromStream((Reader)reader);
                IOUtils.closeQuietly((Reader)reader);
                return blockModel;
            }
            catch (IOException e) {
                BlockModel blockModel = null;
                return blockModel;
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }

        private static void populateGeometryData(ResourceLocation locationIcon, ResourceLocation locationCount, ResourceLocation locationInd, ResourceLocation locationIndBase, BlockDrawers ... blocks) {
            BlockModel slotInfo = Register.getBlockModel(locationIcon);
            BlockModel countInfo = Register.getBlockModel(locationCount);
            BlockModel indInfo = Register.getBlockModel(locationInd);
            BlockModel indBaseInfo = Register.getBlockModel(locationIndBase);
            for (BlockDrawers block : blocks) {
                Vector3f to;
                Vector3f from;
                int i;
                if (block == null) continue;
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)slotInfo.getElements().get((int)i)).from;
                    to = ((BlockElement)slotInfo.getElements().get((int)i)).to;
                    block.labelGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)countInfo.getElements().get((int)i)).from;
                    to = ((BlockElement)countInfo.getElements().get((int)i)).to;
                    block.countGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)indInfo.getElements().get((int)i)).from;
                    to = ((BlockElement)indInfo.getElements().get((int)i)).to;
                    block.indGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)indBaseInfo.getElements().get((int)i)).from;
                    to = ((BlockElement)indBaseInfo.getElements().get((int)i)).to;
                    block.indBaseGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
                }
            }
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.ModifyBakingResult event) {
            if (!ModBlocks.OAK_FULL_DRAWERS_1.isBound()) {
                StorageDrawers.log.warn("Block objects not set in ModelBakeEvent.  Is your mod environment broken?");
                return;
            }
            for (int i = 0; i < 4; ++i) {
                Direction dir = Direction.from2DDataValue((int)i);
                BlockModelRotation rot = BlockModelRotation.by((int)0, (int)((int)dir.toYRot() + 180));
                lockOverlaysFull.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_locked"), Register.getVariant(dir, false))));
                lockOverlaysHalf.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_locked"), Register.getVariant(dir, true))));
                voidOverlaysFull.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_void"), Register.getVariant(dir, false))));
                voidOverlaysHalf.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_void"), Register.getVariant(dir, true))));
                shroudOverlaysFull.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_shroud"), Register.getVariant(dir, false))));
                shroudOverlaysHalf.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_shroud"), Register.getVariant(dir, true))));
                indicator1Full.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), Register.getVariant(dir, false, 1))));
                indicator1Half.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), Register.getVariant(dir, true, 1))));
                indicator2Full.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), Register.getVariant(dir, false, 2))));
                indicator2Half.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), Register.getVariant(dir, true, 2))));
                indicator4Full.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), Register.getVariant(dir, false, 4))));
                indicator4Half.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), Register.getVariant(dir, true, 4))));
                indicatorComp.put(dir, (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_comp_indicator"), Register.getVariant(dir, false))));
            }
            ModBlocks.getDrawers().forEach(blockDrawers -> Register.replaceBlock(event, blockDrawers));
        }

        static String getVariant(Direction dir, boolean half) {
            return "facing=" + dir.getName() + ",half=" + half;
        }

        static String getVariant(Direction dir, boolean half, int slots) {
            return "facing=" + dir.getName() + ",half=" + half + ",slots=" + slots;
        }

        public static void replaceBlock(ModelEvent.ModifyBakingResult event, BlockDrawers block) {
            BakedModel missing = (BakedModel)event.getModels().get(ModelBakery.MISSING_MODEL_LOCATION);
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                ModelResourceLocation modelResource = BlockModelShaper.stateToModelLocation((BlockState)state);
                BakedModel parentModel = (BakedModel)event.getModels().get(modelResource);
                if (parentModel == null) {
                    StorageDrawers.log.warn("Got back null model from ModelBakeEvent.ModelManager for resource " + modelResource.toString());
                    continue;
                }
                if (parentModel == missing) continue;
                if (block.isHalfDepth()) {
                    event.getModels().put(modelResource, new Model2.HalfModel(parentModel));
                    continue;
                }
                event.getModels().put(modelResource, new Model2.FullModel(parentModel));
            }
        }
    }
}

