/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="storagedrawers")
public class CommonEventBusSubscriber {
    @SubscribeEvent
    public static void playerLeftClick(@NotNull PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockDrawers) {
            BlockHitResult hit;
            BlockDrawers blockDrawers = (BlockDrawers)block;
            Player player = event.getEntity();
            if (player.isCreative() && (hit = WorldUtils.rayTraceEyes(level, player, pos)).getType() == HitResult.Type.BLOCK) {
                event.setCanceled(blockDrawers.interactTakeItems(state, level, pos, player, hit));
            }
        }
    }
}

