/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"storagedrawers");
    private static final Set<DeferredHolder<BlockEntityType<?>, ? extends BlockEntityType<? extends BlockEntityDrawers>>> BLOCK_ENTITY_TYPES_WITH_RENDERERS = new HashSet();
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_1 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_1", BlockEntityDrawersStandard.Slot1::new, BlockStandardDrawers.class, 1);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_2 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_2", BlockEntityDrawersStandard.Slot2::new, BlockStandardDrawers.class, 2);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_4 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_4", BlockEntityDrawersStandard.Slot4::new, BlockStandardDrawers.class, 4);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockEntityDrawersComp>> FRACTIONAL_DRAWERS_3 = ModBlockEntities.registerDrawerBlockEntityType("fractional_drawers_3", BlockEntityDrawersComp.Slot3::new, BlockCompDrawers.class, 3);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockEntityController>> CONTROLLER = BLOCK_ENTITY_REGISTER.register("controller", () -> BlockEntityType.Builder.of(BlockEntityController::new, (Block[])new Block[]{(Block)ModBlocks.CONTROLLER.get()}).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockEntityControllerIO>> CONTROLLER_IO = BLOCK_ENTITY_REGISTER.register("controller_io", () -> BlockEntityType.Builder.of(BlockEntityControllerIO::new, (Block[])new Block[]{(Block)ModBlocks.CONTROLLER_IO.get()}).build(null));

    private ModBlockEntities() {
    }

    private static <BE extends BlockEntityDrawers, B extends BlockDrawers> DeferredHolder<BlockEntityType<?>, BlockEntityType<BE>> registerDrawerBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier, Class<B> drawerBlockClass, int size) {
        DeferredHolder<BlockEntityType<?>, BlockEntityType<BE>> ro = ModBlockEntities.registerBlockEntityType(name, blockEntitySupplier, drawerBlockClass, size);
        BLOCK_ENTITY_TYPES_WITH_RENDERERS.add(ro);
        return ro;
    }

    private static <BE extends BaseBlockEntity, B extends BlockDrawers> DeferredHolder<BlockEntityType<?>, BlockEntityType<BE>> registerBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier, Class<B> drawerBlockClass, int size) {
        return BLOCK_ENTITY_REGISTER.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)blockEntitySupplier, (Block[])((Block[])ModBlocks.getDrawersOfTypeAndSize(drawerBlockClass, size).toArray(Block[]::new))).build(null));
    }

    public static void register(IEventBus bus) {
        BLOCK_ENTITY_REGISTER.register(bus);
    }

    public static Set<DeferredHolder<BlockEntityType<?>, ? extends BlockEntityType<? extends BlockEntityDrawers>>> getBlockEntityTypesWithRenderers() {
        return Collections.unmodifiableSet(BLOCK_ENTITY_TYPES_WITH_RENDERERS);
    }
}

