/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMeta;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaSized;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModBlocks {
    public static final DeferredRegister.Blocks BLOCK_REGISTER = DeferredRegister.createBlocks((String)"storagedrawers");
    public static final List<String> EXCLUDE_ITEMS = new ArrayList<String>();
    public static final DeferredBlock<BlockStandardDrawers> OAK_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("oak_full_drawers_1", 1, false);
    public static final DeferredBlock<BlockStandardDrawers> OAK_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("oak_full_drawers_2", 2, false);
    public static final DeferredBlock<BlockStandardDrawers> OAK_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("oak_full_drawers_4", 4, false);
    public static final DeferredBlock<BlockStandardDrawers> OAK_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("oak_half_drawers_1", 1, true);
    public static final DeferredBlock<BlockStandardDrawers> OAK_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("oak_half_drawers_2", 2, true);
    public static final DeferredBlock<BlockStandardDrawers> OAK_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("oak_half_drawers_4", 4, true);
    public static final DeferredBlock<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("spruce_full_drawers_1", 1, false);
    public static final DeferredBlock<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("spruce_full_drawers_2", 2, false);
    public static final DeferredBlock<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("spruce_full_drawers_4", 4, false);
    public static final DeferredBlock<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("spruce_half_drawers_1", 1, true);
    public static final DeferredBlock<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("spruce_half_drawers_2", 2, true);
    public static final DeferredBlock<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("spruce_half_drawers_4", 4, true);
    public static final DeferredBlock<BlockStandardDrawers> BIRCH_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("birch_full_drawers_1", 1, false);
    public static final DeferredBlock<BlockStandardDrawers> BIRCH_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("birch_full_drawers_2", 2, false);
    public static final DeferredBlock<BlockStandardDrawers> BIRCH_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("birch_full_drawers_4", 4, false);
    public static final DeferredBlock<BlockStandardDrawers> BIRCH_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("birch_half_drawers_1", 1, true);
    public static final DeferredBlock<BlockStandardDrawers> BIRCH_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("birch_half_drawers_2", 2, true);
    public static final DeferredBlock<BlockStandardDrawers> BIRCH_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("birch_half_drawers_4", 4, true);
    public static final DeferredBlock<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("jungle_full_drawers_1", 1, false);
    public static final DeferredBlock<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("jungle_full_drawers_2", 2, false);
    public static final DeferredBlock<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("jungle_full_drawers_4", 4, false);
    public static final DeferredBlock<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("jungle_half_drawers_1", 1, true);
    public static final DeferredBlock<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("jungle_half_drawers_2", 2, true);
    public static final DeferredBlock<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("jungle_half_drawers_4", 4, true);
    public static final DeferredBlock<BlockStandardDrawers> ACACIA_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("acacia_full_drawers_1", 1, false);
    public static final DeferredBlock<BlockStandardDrawers> ACACIA_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("acacia_full_drawers_2", 2, false);
    public static final DeferredBlock<BlockStandardDrawers> ACACIA_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("acacia_full_drawers_4", 4, false);
    public static final DeferredBlock<BlockStandardDrawers> ACACIA_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("acacia_half_drawers_1", 1, true);
    public static final DeferredBlock<BlockStandardDrawers> ACACIA_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("acacia_half_drawers_2", 2, true);
    public static final DeferredBlock<BlockStandardDrawers> ACACIA_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("acacia_half_drawers_4", 4, true);
    public static final DeferredBlock<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("dark_oak_full_drawers_1", 1, false);
    public static final DeferredBlock<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("dark_oak_full_drawers_2", 2, false);
    public static final DeferredBlock<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("dark_oak_full_drawers_4", 4, false);
    public static final DeferredBlock<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("dark_oak_half_drawers_1", 1, true);
    public static final DeferredBlock<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("dark_oak_half_drawers_2", 2, true);
    public static final DeferredBlock<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("dark_oak_half_drawers_4", 4, true);
    public static final DeferredBlock<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("crimson_full_drawers_1", 1, false);
    public static final DeferredBlock<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("crimson_full_drawers_2", 2, false);
    public static final DeferredBlock<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("crimson_full_drawers_4", 4, false);
    public static final DeferredBlock<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("crimson_half_drawers_1", 1, true);
    public static final DeferredBlock<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("crimson_half_drawers_2", 2, true);
    public static final DeferredBlock<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("crimson_half_drawers_4", 4, true);
    public static final DeferredBlock<BlockStandardDrawers> WARPED_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("warped_full_drawers_1", 1, false);
    public static final DeferredBlock<BlockStandardDrawers> WARPED_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("warped_full_drawers_2", 2, false);
    public static final DeferredBlock<BlockStandardDrawers> WARPED_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("warped_full_drawers_4", 4, false);
    public static final DeferredBlock<BlockStandardDrawers> WARPED_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock("warped_half_drawers_1", 1, true);
    public static final DeferredBlock<BlockStandardDrawers> WARPED_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock("warped_half_drawers_2", 2, true);
    public static final DeferredBlock<BlockStandardDrawers> WARPED_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock("warped_half_drawers_4", 4, true);
    public static final DeferredBlock<BlockCompDrawers> COMPACTING_DRAWERS_3 = ModBlocks.registerCompactingDrawerBlock("compacting_drawers_3");
    public static final DeferredBlock<BlockTrim> OAK_TRIM = ModBlocks.registerTrimBlock("oak_trim");
    public static final DeferredBlock<BlockTrim> SPRUCE_TRIM = ModBlocks.registerTrimBlock("spruce_trim");
    public static final DeferredBlock<BlockTrim> BIRCH_TRIM = ModBlocks.registerTrimBlock("birch_trim");
    public static final DeferredBlock<BlockTrim> JUNGLE_TRIM = ModBlocks.registerTrimBlock("jungle_trim");
    public static final DeferredBlock<BlockTrim> ACACIA_TRIM = ModBlocks.registerTrimBlock("acacia_trim");
    public static final DeferredBlock<BlockTrim> DARK_OAK_TRIM = ModBlocks.registerTrimBlock("dark_oak_trim");
    public static final DeferredBlock<BlockTrim> CRIMSON_TRIM = ModBlocks.registerTrimBlock("crimson_trim");
    public static final DeferredBlock<BlockTrim> WARPED_TRIM = ModBlocks.registerTrimBlock("warped_trim");
    public static final DeferredBlock<BlockController> CONTROLLER = ModBlocks.registerControllerBlock("controller");
    public static final DeferredBlock<BlockControllerIO> CONTROLLER_IO = ModBlocks.registerControllerIOBlock("controller_io");
    public static final DeferredBlock<BlockMeta> META_LOCKED = ModBlocks.registerMetaBlock("meta_locked");
    public static final DeferredBlock<BlockMeta> META_VOID = ModBlocks.registerMetaBlock("meta_void");
    public static final DeferredBlock<BlockMeta> META_SHROUD = ModBlocks.registerMetaBlock("meta_shroud");
    public static final DeferredBlock<BlockMeta> META_INDICATOR = ModBlocks.registerSizedMetaBlock("meta_indicator");
    public static final DeferredBlock<BlockMeta> META_COMP_INDICATOR = ModBlocks.registerMetaBlock("meta_comp_indicator");

    private ModBlocks() {
    }

    private static DeferredBlock<BlockStandardDrawers> registerWoodenDrawerBlock(String name, int drawerCount, boolean halfDepth) {
        return BLOCK_REGISTER.register(name, () -> new BlockStandardDrawers(drawerCount, halfDepth, ModBlocks.getWoodenDrawerBlockProperties()));
    }

    private static DeferredBlock<BlockCompDrawers> registerCompactingDrawerBlock(String name) {
        return BLOCK_REGISTER.register(name, () -> new BlockCompDrawers(ModBlocks.getStoneDrawerBlockProperties()));
    }

    private static DeferredBlock<BlockTrim> registerTrimBlock(String name) {
        return BLOCK_REGISTER.register(name, () -> new BlockTrim(ModBlocks.getWoodenBlockProperties()));
    }

    private static DeferredBlock<BlockController> registerControllerBlock(String name) {
        return BLOCK_REGISTER.register(name, () -> new BlockController(ModBlocks.getStoneBlockProperties()));
    }

    private static DeferredBlock<BlockControllerIO> registerControllerIOBlock(String name) {
        return BLOCK_REGISTER.register(name, () -> new BlockControllerIO(ModBlocks.getStoneBlockProperties()));
    }

    private static DeferredBlock<BlockMeta> registerMetaBlock(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCK_REGISTER.register(name, () -> new BlockMeta(BlockBehaviour.Properties.of().air()));
    }

    private static DeferredBlock<BlockMeta> registerSizedMetaBlock(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCK_REGISTER.register(name, () -> new BlockMetaSized(BlockBehaviour.Properties.of().air()));
    }

    private static BlockBehaviour.Properties getWoodenBlockProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(3.0f, 4.0f);
    }

    private static BlockBehaviour.Properties getWoodenDrawerBlockProperties() {
        return ModBlocks.getWoodenBlockProperties().isSuffocating(ModBlocks::predFalse).isRedstoneConductor(ModBlocks::predFalse);
    }

    private static BlockBehaviour.Properties getStoneBlockProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(4.0f, 5.0f);
    }

    private static BlockBehaviour.Properties getStoneDrawerBlockProperties() {
        return ModBlocks.getStoneBlockProperties().isSuffocating(ModBlocks::predFalse).isRedstoneConductor(ModBlocks::predFalse);
    }

    public static void register(IEventBus bus) {
        BLOCK_REGISTER.register(bus);
    }

    private static <B extends Block> Stream<B> getBlocksOfType(Class<B> blockClass) {
        return BLOCK_REGISTER.getEntries().stream().map(DeferredHolder::get).filter(blockClass::isInstance).map(blockClass::cast);
    }

    public static Stream<BlockDrawers> getDrawers() {
        return ModBlocks.getBlocksOfType(BlockDrawers.class);
    }

    public static Stream<BlockController> getControllers() {
        return ModBlocks.getBlocksOfType(BlockController.class);
    }

    public static Stream<BlockControllerIO> getControllerIOs() {
        return ModBlocks.getBlocksOfType(BlockControllerIO.class);
    }

    public static <BD extends BlockDrawers> Stream<BD> getDrawersOfType(Class<BD> drawerClass) {
        return ModBlocks.getBlocksOfType(drawerClass);
    }

    public static <BD extends BlockDrawers> Stream<BD> getDrawersOfTypeAndSize(Class<BD> drawerClass, int size) {
        return ModBlocks.getDrawersOfType(drawerClass).filter(blockDrawers -> blockDrawers.getDrawerCount() == size);
    }

    public static <BD extends BlockDrawers> Stream<BD> getDrawersOfTypeAndSizeAndDepth(Class<BD> drawerClass, int size, boolean halfDepth) {
        return ModBlocks.getDrawersOfTypeAndSize(drawerClass, size).filter(blockDrawers -> blockDrawers.isHalfDepth() == halfDepth);
    }

    private static boolean predFalse(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }
}

