/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class DrawerOverlay {
    public boolean showContent = true;
    public boolean showStackLimit = true;
    public boolean showStatus = true;
    public boolean showStackRemainder;
    public boolean respectQuantifyKey;

    public DrawerOverlay() {
        this.showStackRemainder = (Boolean)CommonConfig.INTEGRATION.wailaStackRemainder.get();
        this.respectQuantifyKey = (Boolean)CommonConfig.INTEGRATION.wailaRespectQuantifyKey.get();
    }

    public List<Component> getOverlay(BlockEntityDrawers tile) {
        ArrayList<Component> result = new ArrayList<Component>();
        IDrawerAttributes attr = tile.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY);
        if (attr == null) {
            attr = EmptyDrawerAttributes.EMPTY;
        }
        this.addStackLimit(result, tile, attr);
        this.addStatus(result, tile, attr);
        return result;
    }

    private void addContent(List<Component> result, BlockEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showContent || attr.isConcealed()) {
            return;
        }
        boolean showCounts = !this.respectQuantifyKey || attr.isShowingQuantity();
        IDrawerGroup group = tile.getGroup();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            MutableComponent name = Component.translatable((String)"tooltip.storagedrawers.waila.empty");
            ItemStack stack = drawer.getStoredItemPrototype();
            if (!stack.isEmpty()) {
                MutableComponent stackName = Component.translatable((String)"").append(stack.getDisplayName());
                if (showCounts) {
                    if (drawer.getStoredItemCount() == Integer.MAX_VALUE) {
                        name = stackName.append("[\u221e]");
                    } else if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1) {
                        String text = (i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]";
                        name = stackName.append(text);
                    } else if (this.showStackRemainder) {
                        int stacks = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
                        int remainder = drawer.getStoredItemCount() - stacks * drawer.getStoredItemStackSize();
                        name = stacks > 0 && remainder > 0 ? stackName.append(" [" + stacks + "x" + drawer.getStoredItemStackSize() + " + " + remainder + "]") : (stacks > 0 ? stackName.append(" [" + stacks + "x" + drawer.getStoredItemStackSize() + "]") : stackName.append(" [" + remainder + "]"));
                    } else {
                        name = stackName.append(" [" + drawer.getStoredItemCount() + "]");
                    }
                } else {
                    name = stackName;
                }
            }
            result.add((Component)Component.translatable((String)"tooltip.storagedrawers.waila.drawer", (Object[])new Object[]{i + 1, name}));
        }
    }

    private void addStackLimit(List<Component> result, BlockEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showStackLimit) {
            return;
        }
        if (attr.isUnlimitedStorage() || tile.getDrawerAttributes().isUnlimitedVending()) {
            result.add((Component)Component.translatable((String)"tooltip.storagedrawers.waila.nolimit"));
        } else {
            int multiplier = tile.upgrades().getStorageMultiplier();
            int limit = tile.getEffectiveDrawerCapacity() * multiplier;
            result.add((Component)Component.translatable((String)"tooltip.storagedrawers.waila.limit", (Object[])new Object[]{limit, multiplier}));
        }
    }

    private void addStatus(List<Component> result, BlockEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showStatus) {
            return;
        }
        ArrayList<MutableComponent> attribs = new ArrayList<MutableComponent>();
        if (attr.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attribs.add(Component.translatable((String)"tooltip.storagedrawers.waila.locked"));
        }
        if (attr.isVoid()) {
            attribs.add(Component.translatable((String)"tooltip.storagedrawers.waila.void"));
        }
        if (!attribs.isEmpty()) {
            result.add((Component)attribs.stream().reduce((a, b) -> a.append((Component)Component.literal((String)", ")).append((Component)b)).get());
        }
    }
}

