/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.gui.StorageGuiGraphics;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryUpgrade;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotDrawer;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerDrawers
extends AbstractContainerMenu {
    private static final int InventoryX = 8;
    private static final int InventoryY = 117;
    private static final int HotbarY = 175;
    private static final int UpgradeX = 26;
    private static final int UpgradeY = 86;
    private final Container upgradeInventory;
    private final List<Slot> storageSlots;
    private final List<Slot> upgradeSlots;
    private final List<Slot> playerSlots;
    private final List<Slot> hotbarSlots;
    @OnlyIn(value=Dist.CLIENT)
    public StorageGuiGraphics activeGuiGraphics;
    private final boolean isRemote;

    public ContainerDrawers(@Nullable MenuType<?> type, int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(type, windowId, playerInv, ContainerDrawers.getBlockEntity(playerInv, data.readBlockPos()));
    }

    protected static BlockEntityDrawers getBlockEntity(Inventory playerInv, BlockPos pos) {
        Level level = playerInv.player.getCommandSenderWorld();
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityDrawers.class);
        if (blockEntity != null) {
            return blockEntity;
        }
        StorageDrawers.log.error("Expected a drawers tile entity at " + String.valueOf(pos));
        return null;
    }

    public ContainerDrawers(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, BlockEntityDrawers tileEntity) {
        super(type, windowId);
        int i;
        int drawerCount = 0;
        this.upgradeInventory = new InventoryUpgrade(tileEntity);
        Block block = tileEntity.getBlockState().getBlock();
        IDrawerGroup group = tileEntity.getGroup();
        if (block instanceof BlockDrawers) {
            drawerCount = ((BlockDrawers)block).getDrawerCount();
        }
        this.storageSlots = new ArrayList<Slot>();
        for (i = 0; i < drawerCount; ++i) {
            if (!group.getDrawer(i).isEnabled()) continue;
            this.storageSlots.add(this.addSlot(new SlotDrawer(this, group, i, this.getStorageSlotX(i), this.getStorageSlotY(i))));
        }
        this.upgradeSlots = new ArrayList<Slot>();
        for (i = 0; i < 7; ++i) {
            this.upgradeSlots.add(this.addSlot(new SlotUpgrade(this.upgradeInventory, i, 26 + i * 18, 86)));
        }
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 175)));
        }
        this.isRemote = playerInventory.player.getCommandSenderWorld().isClientSide;
    }

    public void setLastAccessedItem(ItemStack stack) {
        if (this.isRemote && this.activeGuiGraphics != null) {
            this.activeGuiGraphics.overrideStack = stack;
        }
    }

    protected int getStorageSlotX(int slot) {
        return 0;
    }

    protected int getStorageSlotY(int slot) {
        return 0;
    }

    public List<Slot> getStorageSlots() {
        return this.storageSlots;
    }

    public List<Slot> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.upgradeInventory.stillValid(player);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        int storageStart = this.storageSlots.get((int)0).index;
        int storageEnd = this.storageSlots.get((int)(this.storageSlots.size() - 1)).index + 1;
        int upgradeStart = this.upgradeSlots.get((int)0).index;
        int upgradeEnd = this.upgradeSlots.get((int)(this.upgradeSlots.size() - 1)).index + 1;
        int inventoryStart = this.playerSlots.get((int)0).index;
        int hotbarStart = this.hotbarSlots.get((int)0).index;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).index + 1;
        if (slot.hasItem()) {
            ItemStack slotStack;
            block17: {
                slotStack = slot.getItem();
                itemStack = slotStack.copy();
                if (slotIndex >= upgradeStart && slotIndex < upgradeEnd) {
                    if (!this.moveItemStackTo(slotStack, inventoryStart, hotbarEnd, true)) {
                        return ItemStack.EMPTY;
                    }
                    slot.onQuickCraft(slotStack, itemStack);
                } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd && !slotStack.isEmpty()) {
                    if (slotStack.getItem() instanceof ItemUpgrade) {
                        ItemStack slotStack1 = slotStack.copy();
                        slotStack1.setCount(1);
                        if (!this.moveItemStackTo(slotStack1, upgradeStart, upgradeEnd, false)) {
                            if (slotIndex < hotbarStart ? !this.moveItemStackTo(slotStack, hotbarStart, hotbarEnd, false) : !this.moveItemStackTo(slotStack, inventoryStart, hotbarStart, false)) {
                                return ItemStack.EMPTY;
                            }
                            break block17;
                        } else {
                            slotStack.shrink(1);
                            if (slotStack.getCount() == 0) {
                                slot.set(ItemStack.EMPTY);
                            } else {
                                slot.setChanged();
                            }
                            slot.onTake(player, slotStack);
                            return ItemStack.EMPTY;
                        }
                    }
                    if (slotIndex < hotbarStart ? !this.moveItemStackTo(slotStack, hotbarStart, hotbarEnd, false) : !this.moveItemStackTo(slotStack, inventoryStart, hotbarStart, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (!this.moveItemStackTo(slotStack, inventoryStart, hotbarEnd, false)) {
                    return ItemStack.EMPTY;
                }
            }
            int slotStackSize = slotStack.getCount();
            if (slotStackSize == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStackSize == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }
}

