/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class InventoryUpgrade
implements Container {
    private static final int upgradeCapacity = 7;
    private final BlockEntityDrawers blockEntityDrawers;

    public InventoryUpgrade(BlockEntityDrawers blockEntityDrawers) {
        this.blockEntityDrawers = blockEntityDrawers;
    }

    public int getContainerSize() {
        return 7;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 7; ++i) {
            if (this.blockEntityDrawers.upgrades().getUpgrade(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.blockEntityDrawers.upgrades().getUpgrade(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int count) {
        ItemStack stack = this.blockEntityDrawers.upgrades().getUpgrade(slot);
        if (count > 0) {
            this.blockEntityDrawers.upgrades().setUpgrade(slot, ItemStack.EMPTY);
        }
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, @NotNull ItemStack item) {
        this.blockEntityDrawers.upgrades().setUpgrade(slot, item);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void setChanged() {
        this.blockEntityDrawers.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        BlockPos pos = this.blockEntityDrawers.getBlockPos();
        if (this.blockEntityDrawers.getLevel() == null || this.blockEntityDrawers.getLevel().getBlockEntity(pos) != this.blockEntityDrawers) {
            return false;
        }
        return !(player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) > 64.0);
    }

    public void startOpen(@NotNull Player player) {
    }

    public void stopOpen(@NotNull Player player) {
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack item) {
        return this.blockEntityDrawers.upgrades().canAddUpgrade(item);
    }

    public void clearContent() {
    }

    public boolean canAddUpgrade(@NotNull ItemStack item) {
        return this.blockEntityDrawers.upgrades().canAddUpgrade(item);
    }

    public boolean canRemoveStorageUpgrade(int slot) {
        return this.blockEntityDrawers.upgrades().canRemoveUpgrade(slot);
    }

    public boolean canSwapUpgrade(int slot, @NotNull ItemStack item) {
        return this.blockEntityDrawers.upgrades().canSwapUpgrade(slot, item);
    }
}

