/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ItemDrawers
extends BlockItem {
    public ItemDrawers(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        MutableComponent textCapacity = Component.translatable((String)"tooltip.storagedrawers.drawers.capacity", (Object[])new Object[]{this.getCapacityForBlock(stack)});
        tooltip.add((Component)Component.literal((String)"").append((Component)textCapacity).withStyle(ChatFormatting.GRAY));
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null) {
            MutableComponent textSealed = Component.translatable((String)"tooltip.storagedrawers.drawers.sealed");
            tooltip.add((Component)Component.literal((String)"").append((Component)textSealed).withStyle(ChatFormatting.YELLOW));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Component getDescription() {
        return Component.translatable((String)(this.getDescriptionId() + ".desc"));
    }

    private int getCapacityForBlock(@NotNull ItemStack itemStack) {
        Block block = Block.byItem((Item)itemStack.getItem());
        if (block instanceof BlockDrawers) {
            BlockDrawers blockDrawers = (BlockDrawers)block;
            return blockDrawers.getStorageUnits() * CommonConfig.GENERAL.getBaseStackStorage();
        }
        return 0;
    }
}

