/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ItemUpgrade
extends Item {
    private static int nextGroupId = 0;
    private boolean allowMultiple;
    private final int groupId;

    public ItemUpgrade(Item.Properties properties) {
        this(properties, ItemUpgrade.getNextGroupId());
    }

    protected ItemUpgrade(Item.Properties properties, int groupId) {
        super(properties);
        this.groupId = groupId;
    }

    protected static int getNextGroupId() {
        int groupId = nextGroupId++;
        return groupId;
    }

    public int getUpgradeGroup() {
        return this.groupId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"").append(this.getDescription()).withStyle(ChatFormatting.GRAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Component getDescription() {
        return Component.translatable((String)(this.getDescriptionId() + ".desc"));
    }

    public void setAllowMultiple(boolean allow) {
        this.allowMultiple = allow;
    }

    public boolean getAllowMultiple() {
        return this.allowMultiple;
    }
}

