/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CountUpdateMessage(int x, int y, int z, int slot, int count) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CountUpdateMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"storagedrawers", (String)"count_update"));
    public static final StreamCodec<FriendlyByteBuf, CountUpdateMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CountUpdateMessage::x, (StreamCodec)ByteBufCodecs.INT, CountUpdateMessage::y, (StreamCodec)ByteBufCodecs.INT, CountUpdateMessage::z, (StreamCodec)ByteBufCodecs.INT, CountUpdateMessage::slot, (StreamCodec)ByteBufCodecs.INT, CountUpdateMessage::count, CountUpdateMessage::new);

    public CountUpdateMessage(BlockPos pos, int slot, int count) {
        this(pos.getX(), pos.getY(), pos.getZ(), slot, count);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CountUpdateMessage data, IPayloadContext context) {
        if (Dist.CLIENT.isClient()) {
            CountUpdateMessage.handleClient(data, context);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(CountUpdateMessage data, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockPos pos;
            BlockEntity blockEntity;
            ClientLevel world = Minecraft.getInstance().level;
            if (world != null && (blockEntity = world.getBlockEntity(pos = new BlockPos(data.x, data.y, data.z))) instanceof BlockEntityDrawers) {
                ((BlockEntityDrawers)blockEntity).clientUpdateCount(data.slot, data.count);
            }
        }).exceptionally(e -> null);
    }
}

