/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CompactingHelper {
    private static final InventoryLookup lookup1 = new InventoryLookup(1, 1);
    private static final InventoryLookup lookup2 = new InventoryLookup(2, 2);
    private static final InventoryLookup lookup3 = new InventoryLookup(3, 3);
    private final Level world;

    public CompactingHelper(Level world) {
        this.world = world;
    }

    @NotNull
    public Result findHigherTier(@NotNull ItemStack stack) {
        ItemStack modMatch;
        CompTierRegistry.Record record;
        boolean debugTrace = (Boolean)CommonConfig.GENERAL.debugTrace.get();
        if (!this.world.isClientSide && debugTrace) {
            StorageDrawers.log.info("Finding ascending candidates for " + stack.toString());
        }
        if ((record = StorageDrawers.compRegistry.findHigherTier(stack)) != null) {
            if (!this.world.isClientSide && debugTrace) {
                StorageDrawers.log.info("Found " + record.upper.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.upper, record.convRate);
        }
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        int lookupSize = this.setupLookup(lookup3, stack);
        List<ItemStack> fwdCandidates = this.findAllMatchingRecipes((CraftingContainer)lookup3);
        if (fwdCandidates.size() == 0) {
            lookupSize = this.setupLookup(lookup2, stack);
            fwdCandidates = this.findAllMatchingRecipes((CraftingContainer)lookup2);
        }
        if (fwdCandidates.size() > 0) {
            block0: for (ItemStack match : fwdCandidates) {
                this.setupLookup(lookup1, match);
                List<ItemStack> backCandidates = this.findAllMatchingRecipes((CraftingContainer)lookup1);
                for (ItemStack comp : backCandidates) {
                    if (comp.getCount() != lookupSize || !ItemStackMatcher.areItemsEqual(comp, stack)) continue;
                    candidates.add(match);
                    if (this.world.isClientSide || !debugTrace) continue block0;
                    StorageDrawers.log.info("Found ascending candidate for " + stack.toString() + ": " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
                    continue block0;
                }
            }
        }
        if (!(modMatch = this.findMatchingModCandidate(stack, candidates)).isEmpty()) {
            return new Result(modMatch, lookupSize);
        }
        if (candidates.size() > 0) {
            return new Result((ItemStack)candidates.get(0), lookupSize);
        }
        if (!this.world.isClientSide && debugTrace) {
            StorageDrawers.log.info("No candidates found");
        }
        return new Result(ItemStack.EMPTY, 0);
    }

    @NotNull
    public Result findLowerTier(@NotNull ItemStack stack) {
        CompTierRegistry.Record record;
        boolean debugTrace = (Boolean)CommonConfig.GENERAL.debugTrace.get();
        if (!this.world.isClientSide && debugTrace) {
            StorageDrawers.log.info("Finding descending candidates for " + stack.toString());
        }
        if ((record = StorageDrawers.compRegistry.findLowerTier(stack)) != null) {
            if (!this.world.isClientSide && debugTrace) {
                StorageDrawers.log.info("Found " + record.lower.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.lower, record.convRate);
        }
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> candidatesRate = new HashMap<ItemStack, Integer>();
        for (RecipeHolder recipe : this.world.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING)) {
            ItemStack match;
            ItemStack output = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.world.registryAccess());
            if (!ItemStackMatcher.areItemsEqual(stack, output) || (match = this.tryMatch(stack, (NonNullList<Ingredient>)((CraftingRecipe)recipe.value()).getIngredients())).isEmpty()) continue;
            int lookupSize = this.setupLookup(lookup1, output);
            List<ItemStack> compMatches = this.findAllMatchingRecipes((CraftingContainer)lookup1);
            for (ItemStack comp : compMatches) {
                int recipeSize = ((CraftingRecipe)recipe.value()).getIngredients().size();
                if (ItemStackMatcher.areItemsEqual(match, comp) && comp.getCount() == recipeSize) {
                    candidates.add(match);
                    candidatesRate.put(match, recipeSize);
                    if (this.world.isClientSide || !debugTrace) continue;
                    StorageDrawers.log.info("Found descending candidate for " + stack.toString() + ": " + match.toString() + " size=" + recipeSize + ", inverse=" + comp.toString());
                    continue;
                }
                if (this.world.isClientSide || !debugTrace) continue;
                StorageDrawers.log.info("Back-check failed for " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
            }
        }
        ItemStack modMatch = this.findMatchingModCandidate(stack, candidates);
        if (!modMatch.isEmpty()) {
            return new Result(modMatch, (Integer)candidatesRate.get(modMatch));
        }
        if (candidates.size() > 0) {
            ItemStack match = (ItemStack)candidates.get(0);
            return new Result(match, (Integer)candidatesRate.get(match));
        }
        if (!this.world.isClientSide && debugTrace) {
            StorageDrawers.log.info("No candidates found");
        }
        return new Result(ItemStack.EMPTY, 0);
    }

    private List<ItemStack> findAllMatchingRecipes(CraftingContainer crafting) {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        CraftingInput input = crafting.asCraftInput();
        for (RecipeHolder recipe : this.world.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)input, this.world)) {
            ItemStack result;
            if (!((CraftingRecipe)recipe.value()).matches((RecipeInput)input, this.world) || (result = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)this.world.registryAccess())).isEmpty()) continue;
            candidates.add(result);
        }
        return candidates;
    }

    @NotNull
    private ItemStack findMatchingModCandidate(@NotNull ItemStack reference, List<ItemStack> candidates) {
        ResourceLocation referenceName = BuiltInRegistries.ITEM.getKey((Object)reference.getItem());
        if (referenceName != null) {
            for (ItemStack candidate : candidates) {
                ResourceLocation matchName = BuiltInRegistries.ITEM.getKey((Object)candidate.getItem());
                if (matchName == null || !referenceName.getNamespace().equals(matchName.getPath())) continue;
                return candidate;
            }
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    private ItemStack tryMatch(@NotNull ItemStack stack, NonNullList<Ingredient> ingredients) {
        if (ingredients.size() != 9 && ingredients.size() != 4) {
            return ItemStack.EMPTY;
        }
        Ingredient refIngredient = (Ingredient)ingredients.get(0);
        ItemStack[] refMatchingStacks = refIngredient.getItems();
        if (refMatchingStacks.length == 0) {
            return ItemStack.EMPTY;
        }
        int n = ingredients.size();
        for (int i = 1; i < n; ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            @NotNull ItemStack match = ItemStack.EMPTY;
            for (ItemStack ingItemMatch : refMatchingStacks) {
                if (!ingredient.test(ingItemMatch)) continue;
                match = ingItemMatch;
                break;
            }
            if (!match.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        ItemStack match = this.findMatchingModCandidate(stack, Arrays.asList(refMatchingStacks));
        if (match.isEmpty()) {
            match = refMatchingStacks[0];
        }
        return match;
    }

    private int setupLookup(InventoryLookup inv, @NotNull ItemStack stack) {
        int n = inv.getContainerSize();
        for (int i = 0; i < n; ++i) {
            inv.setItem(i, stack);
        }
        return inv.getContainerSize();
    }

    public static class Result {
        @NotNull
        private final ItemStack stack;
        private final int size;

        public Result(@NotNull ItemStack stack, int size) {
            this.stack = stack;
            this.size = size;
        }

        @NotNull
        public ItemStack getStack() {
            return this.stack;
        }

        public int getSize() {
            return this.size;
        }
    }

    private static class InventoryLookup
    extends TransientCraftingContainer {
        private final ItemStack[] stackList;

        public InventoryLookup(int width, int height) {
            super(null, width, height);
            this.stackList = new ItemStack[width * height];
            Arrays.fill(this.stackList, ItemStack.EMPTY);
        }

        public int getContainerSize() {
            return this.stackList.length;
        }

        @NotNull
        public ItemStack getItem(int slot) {
            return slot >= this.getContainerSize() ? ItemStack.EMPTY : this.stackList[slot];
        }

        @NotNull
        public ItemStack removeItemNoUpdate(int slot) {
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack removeItem(int slot, int count) {
            return ItemStack.EMPTY;
        }

        public void setItem(int slot, @NotNull ItemStack stack) {
            this.stackList[slot] = stack;
        }
    }
}

