/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.neoforge.mixin;

import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.services.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import org.joml.Matrix4fStack;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GuiGraphics.class})
public class GuiGraphicsMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow(remap=false)
    private ItemStack tooltipStack = ItemStack.EMPTY;
    private int storedTooltipWidth;
    private int storedTooltipHeight;
    private Vector2ic storedPostPos;
    private int xChange = 0;
    private int yChange = 0;

    @Inject(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, at={@At(value="INVOKE", target="Lorg/joml/Vector2ic;x()I", shift=At.Shift.BEFORE, remap=false)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    @Group(name="storeLocals", min=1, max=1)
    private void storeLocals(Font font, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, CallbackInfo info, RenderTooltipEvent.Pre preEvent, int tooltipWidth, int tooltipHeight, int tooltipWidth2, int tooltipHeight2, Vector2ic postPos) {
        this.storedTooltipWidth = tooltipWidth2;
        this.storedTooltipHeight = tooltipHeight2;
        this.storedPostPos = postPos;
    }

    @Inject(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, at={@At(value="TAIL")})
    private void renderTooltipInternalTail(Font font, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, CallbackInfo info) {
        AbstractContainerScreen containerScreen;
        Slot hoveredSlot;
        GuiGraphics self = (GuiGraphics)this;
        Screen currentScreen = this.minecraft.screen;
        ItemStack containerStack = ItemStack.EMPTY;
        if (currentScreen != null && currentScreen instanceof AbstractContainerScreen && (hoveredSlot = (containerScreen = (AbstractContainerScreen)currentScreen).getSlotUnderMouse()) != null) {
            containerStack = hoveredSlot.getItem();
        }
        if (containerStack.isEmpty()) {
            containerStack = this.tooltipStack;
        }
        if (!containerStack.isEmpty() && !components.isEmpty()) {
            RenderTooltipEvents.POSTEXT.invoker().onPost(containerStack, self, this.storedPostPos.x(), this.storedPostPos.y(), font, this.storedTooltipWidth, this.storedTooltipHeight, components, false, 0);
        }
        if (Services.getPlatformHelper().isModLoaded("andromeda") && this.minecraft.player != null && this.tooltipStack == this.minecraft.player.getMainHandItem()) {
            Matrix4fStack poseStack = RenderSystem.getModelViewStack();
            poseStack.translate((float)(-this.xChange), (float)(-this.yChange), 0.0f);
            RenderSystem.applyModelViewMatrix();
        }
        this.tooltipStack = ItemStack.EMPTY;
        this.xChange = 0;
        this.yChange = 0;
    }
}

