/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.neoforge.services;

import com.anthonyhilyard.iceberg.neoforge.services.VertexConsumerEmbeddium;
import com.anthonyhilyard.iceberg.renderer.CheckedBufferSource;
import com.anthonyhilyard.iceberg.renderer.VertexCollector;
import com.anthonyhilyard.iceberg.services.IBufferSourceFactory;
import com.anthonyhilyard.iceberg.util.UnsafeUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.embeddedt.embeddium.api.vertex.attributes.CommonVertexAttribute;
import org.embeddedt.embeddium.api.vertex.buffer.VertexBufferWriter;
import org.embeddedt.embeddium.api.vertex.format.VertexFormatDescription;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;

public class NeoForgeBufferSourceFactory
implements IBufferSourceFactory {
    @Override
    public CheckedBufferSource createCheckedBufferSource(Object bufferSource) {
        return new CheckedBufferSource(this, (MultiBufferSource)bufferSource){

            @Override
            public VertexConsumer getBuffer(RenderType renderType) {
                final VertexConsumer vertexConsumer = this.bufferSource.getBuffer(renderType);
                VertexConsumerEmbeddium vertexConsumerWrap = new VertexConsumerEmbeddium(){

                    public VertexConsumer addVertex(float x, float y, float z) {
                        hasRendered = true;
                        return vertexConsumer.addVertex(x, y, z);
                    }

                    public VertexConsumer setColor(int r, int g, int b, int a) {
                        return vertexConsumer.setColor(r, g, b, a);
                    }

                    public VertexConsumer setUv(float u, float v) {
                        return vertexConsumer.setUv(u, v);
                    }

                    public VertexConsumer setUv1(int u, int v) {
                        return vertexConsumer.setUv1(u, v);
                    }

                    public VertexConsumer setUv2(int u, int v) {
                        return vertexConsumer.setUv2(u, v);
                    }

                    public VertexConsumer setNormal(float x, float y, float z) {
                        return vertexConsumer.setNormal(x, y, z);
                    }

                    public void push(MemoryStack memoryStack, long pointer, int count, VertexFormatDescription format) {
                        hasRendered = true;
                        ((VertexBufferWriter)vertexConsumer).push(memoryStack, pointer, count, format);
                    }
                };
                return vertexConsumerWrap;
            }
        };
    }

    @Override
    public VertexCollector createVertexCollector() {
        return new VertexCollector(this){

            @Override
            public VertexConsumer getBuffer(RenderType renderType) {
                return new VertexConsumerEmbeddium(){

                    public VertexConsumer addVertex(float x, float y, float z) {
                        if (currentAlpha >= 25) {
                            vertices.add(new Vector3f((Vector3fc)currentVertex.set(x, y, z)));
                        }
                        currentAlpha = 255;
                        return this;
                    }

                    public VertexConsumer setColor(int r, int g, int b, int a) {
                        currentAlpha = a;
                        return this;
                    }

                    public VertexConsumer setUv(float u, float v) {
                        return this;
                    }

                    public VertexConsumer setUv1(int u, int v) {
                        return this;
                    }

                    public VertexConsumer setUv2(int u, int v) {
                        return this;
                    }

                    public VertexConsumer setNormal(float x, float y, float z) {
                        return this;
                    }

                    public void push(MemoryStack memoryStack, long pointer, int count, VertexFormatDescription format) {
                        for (int i = 0; i < count; ++i) {
                            float x = UnsafeUtil.readFloat(pointer + (long)(i * format.stride()) + (long)format.getElementOffset(CommonVertexAttribute.POSITION));
                            float y = UnsafeUtil.readFloat(pointer + (long)(i * format.stride()) + (long)format.getElementOffset(CommonVertexAttribute.POSITION) + 4L);
                            float z = UnsafeUtil.readFloat(pointer + (long)(i * format.stride()) + (long)format.getElementOffset(CommonVertexAttribute.POSITION) + 8L);
                            int a = UnsafeUtil.readByte(pointer + (long)(i * format.stride()) + (long)format.getElementOffset(CommonVertexAttribute.COLOR) + 3L) & 0xFF;
                            if (a < 25) continue;
                            vertices.add(new Vector3f(x, y, z));
                        }
                    }
                };
            }
        };
    }
}

