/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.renderer;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.services.Services;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VertexCollector
implements MultiBufferSource {
    protected final Set<Vector3f> vertices = Sets.newHashSet();
    protected final Vector3f currentVertex = new Vector3f();
    protected int currentAlpha = 255;
    private static Boolean useSodiumVersion = null;

    protected VertexCollector() {
    }

    public static VertexCollector create() {
        if (useSodiumVersion == null) {
            try {
                useSodiumVersion = Services.getPlatformHelper().getPlatformName().contentEquals("Fabric") && Services.getPlatformHelper().isModLoaded("sodium") && Services.getPlatformHelper().modVersionMeets("sodium", "0.5.9");
                useSodiumVersion = useSodiumVersion | (Services.getPlatformHelper().getPlatformName().contentEquals("NeoForge") && Services.getPlatformHelper().isModLoaded("embeddium") && Services.getPlatformHelper().modVersionMeets("embeddium", "1.0.0"));
            }
            catch (Exception e) {
                Iceberg.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (useSodiumVersion != null && useSodiumVersion.booleanValue()) {
            try {
                return Services.getBufferSourceFactory().createVertexCollector();
            }
            catch (Exception e) {
                Iceberg.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return new VertexCollector();
    }

    public VertexConsumer getBuffer(RenderType renderType) {
        return new VertexConsumer(){

            public VertexConsumer addVertex(float x, float y, float z) {
                if (VertexCollector.this.currentAlpha >= 25) {
                    VertexCollector.this.vertices.add(new Vector3f((Vector3fc)VertexCollector.this.currentVertex.set(x, y, z)));
                }
                VertexCollector.this.currentAlpha = 255;
                return this;
            }

            public VertexConsumer setColor(int r, int g, int b, int a) {
                VertexCollector.this.currentAlpha = a;
                return this;
            }

            public VertexConsumer setUv(float u, float v) {
                return this;
            }

            public VertexConsumer setUv1(int u, int v) {
                return this;
            }

            public VertexConsumer setUv2(int u, int v) {
                return this;
            }

            public VertexConsumer setNormal(float x, float y, float z) {
                return this;
            }
        };
    }

    public Set<Vector3f> getVertices() {
        return this.vertices;
    }
}

