/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.player;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.player.api.IPlayerClaimInfoAPI;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.api.IServerClaimsManagerAPI;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.protection.ChunkProtection;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ServerPlayerClaimWelcomer {
    public void onPlayerTick(ServerPlayerData mainCap, ServerPlayer player, IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        IServerClaimsManagerAPI claimsManager;
        IPlayerChunkClaim currentClaim;
        IPlayerChunkClaim lastClaimCheck = mainCap.getLastClaimCheck();
        if (!Objects.equals(lastClaimCheck, currentClaim = (claimsManager = serverData.getServerClaimsManager()).get(player.level().dimension().location(), player.chunkPosition()))) {
            MutableComponent subTitleText;
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            UUID currentClaimId = currentClaim == null ? null : currentClaim.getPlayerId();
            IPlayerClaimInfoAPI playerClaimInfo = currentClaim == null ? null : serverData.getServerClaimsManager().getPlayerInfo(currentClaimId);
            boolean isOwner = !mainCap.isClaimsNonallyMode() && currentClaim != null && Objects.equals(currentClaimId, player.getUUID());
            boolean hasAccess = isOwner || ((ChunkProtection)serverData.getChunkProtection()).hasChunkAccess(((ChunkProtection)serverData.getChunkProtection()).getClaimConfig(serverData.getPlayerConfigs(), currentClaim), (Entity)player, null);
            IPlayerConfig claimConfig = ((ChunkProtection)serverData.getChunkProtection()).getClaimConfig(serverData.getPlayerConfigs(), currentClaim);
            String customName = claimConfig.getEffective(PlayerConfigOptions.CLAIMS_NAME);
            int claimColor = claimConfig.getEffective(PlayerConfigOptions.CLAIMS_COLOR);
            if (playerClaimInfo == null) {
                subTitleText = adaptiveLocalizer.getFor(player, customName == null || customName.isEmpty() ? "gui.xaero_pac_title_entered_wilderness" : customName, new Object[0]);
            } else {
                MutableComponent forceloadedComponent;
                MutableComponent mutableComponent = forceloadedComponent = currentClaim.isForceloadable() ? adaptiveLocalizer.getFor(player, "gui.xaero_pac_marked_for_forceload", new Object[0]) : Component.literal((String)"");
                MutableComponent properDesc = Objects.equals(currentClaimId, PlayerConfig.SERVER_CLAIM_UUID) ? adaptiveLocalizer.getFor(player, "gui.xaero_pac_title_entered_server_claim", forceloadedComponent) : (Objects.equals(currentClaimId, PlayerConfig.EXPIRED_CLAIM_UUID) ? adaptiveLocalizer.getFor(player, "gui.xaero_pac_title_entered_expired_claim", forceloadedComponent) : adaptiveLocalizer.getFor(player, "gui.xaero_pac_title_entered_claim", playerClaimInfo.getPlayerUsername(), forceloadedComponent));
                if (customName != null && !customName.isEmpty()) {
                    subTitleText = Component.literal((String)(customName + " - "));
                    subTitleText.getSiblings().add(properDesc);
                } else {
                    subTitleText = properDesc;
                }
            }
            subTitleText = subTitleText.withStyle(s -> s.withColor(isOwner ? ChatFormatting.DARK_GREEN : (hasAccess ? ChatFormatting.GOLD : ChatFormatting.DARK_RED)));
            MutableComponent subTitle = Component.literal((String)"\u25a1 ").withStyle(s -> s.withColor(claimColor));
            subTitle.getSiblings().add(subTitleText);
            subTitle.getSiblings().add(Component.literal((String)" \u25a1").withStyle(s -> s.withColor(claimColor)));
            ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket((Component)subTitle);
            player.connection.send((Packet)packet);
            mainCap.setLastClaimCheck(currentClaim);
        }
    }
}

