/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfigDeletionStarter;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigSubDeleteCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        Command<CommandSourceStack> regularExecutor = ConfigSubDeleteCommand.getExecutor(PlayerConfigType.PLAYER);
        Command<CommandSourceStack> serverExecutor = ConfigSubDeleteCommand.getExecutor(PlayerConfigType.SERVER);
        SuggestionProvider<CommandSourceStack> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<CommandSourceStack> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(((LiteralArgumentBuilder)Commands.literal((String)"for").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"server-claims-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(this.getMainCommandPart(serverSubConfigSuggestionProvider, serverExecutor)));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<CommandSourceStack> getMainCommandPart(SuggestionProvider<CommandSourceStack> subConfigSuggestionProvider, Command<CommandSourceStack> executor) {
        return (LiteralArgumentBuilder)Commands.literal((String)"sub").then(Commands.literal((String)"delete").then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(subConfigSuggestionProvider).executes(executor)));
    }

    private static Command<CommandSourceStack> getExecutor(PlayerConfigType type) {
        return context -> {
            UUID configPlayerUUID;
            ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            String inputSubId = StringArgumentType.getString((CommandContext)context, (String)"sub-id");
            GameProfile inputPlayer = null;
            if (type == PlayerConfigType.PLAYER) {
                inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<CommandSourceStack>)context, sourcePlayer, "gui.xaero_pac_config_delete_sub_too_many_targets", "gui.xaero_pac_config_delete_sub_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.getId();
            } else {
                configPlayerUUID = PlayerConfig.SERVER_CLAIM_UUID;
            }
            ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(sourcePlayer);
            if (serverData.getServerTickHandler().getTickCounter() == playerData.getLastSubConfigCreationTick()) {
                return 0;
            }
            playerData.setLastSubConfigCreationTick(serverData.getServerTickHandler().getTickCounter());
            PlayerConfig playerConfig = (PlayerConfig)serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID);
            IPlayerConfig result = playerConfig.getSubConfig(inputSubId);
            if (result == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_delete_sub_not_exist", new Object[0]));
                return 0;
            }
            if (result == playerConfig) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_delete_sub_cant_main", new Object[0]));
                return 0;
            }
            IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)serverData.getServerClaimsManager().getPlayerInfo(configPlayerUUID);
            if (playerInfo.hasReplacementTasks()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_delete_sub_already_replacing", new Object[0]));
                return 0;
            }
            new PlayerSubConfigDeletionStarter().start(sourcePlayer, playerInfo, result, serverData);
            return 1;
        };
    }
}

