/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.localization;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.api.IAdaptiveLocalizerAPI;

public class AdaptiveLocalizer
implements IAdaptiveLocalizerAPI {
    private final Map<String, String> defaultTranslations;

    public AdaptiveLocalizer(Map<String, String> defaultTranslations) {
        this.defaultTranslations = defaultTranslations;
    }

    @Override
    @Nonnull
    public MutableComponent getFor(@Nonnull ServerPlayer player, @Nonnull String key, Object ... args) {
        ServerPlayerData playerDataAPI = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerDataAPI.hasMod()) {
            return Component.translatable((String)key, (Object[])args);
        }
        return this.getServerLocalizedComponent(key, args);
    }

    @Override
    @Nonnull
    public Component getFor(@Nonnull ServerPlayer player, @Nonnull Component component) {
        ComponentContents componentContents = component.getContents();
        if (!(componentContents instanceof TranslatableContents)) {
            return component;
        }
        TranslatableContents translatableContents = (TranslatableContents)componentContents;
        ServerPlayerData playerDataAPI = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerDataAPI.hasMod()) {
            return component;
        }
        String key = translatableContents.getKey();
        Object[] args = translatableContents.getArgs();
        MutableComponent result = this.getServerLocalizedComponent(key, args).setStyle(component.getStyle());
        if (component.getSiblings() != null) {
            result.getSiblings().addAll(component.getSiblings());
        }
        return result;
    }

    private MutableComponent getServerLocalizedComponent(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Component component;
            Object object = args[i];
            if (!(object instanceof Component) || !((object = (component = (Component)object).getContents()) instanceof TranslatableContents)) continue;
            TranslatableContents translatableContents = (TranslatableContents)object;
            args[i] = this.getServerLocalizedComponent(translatableContents.getKey(), translatableContents.getArgs());
        }
        return Component.translatable((String)this.defaultTranslations.getOrDefault(key, key), (Object[])args);
    }

    public String getDefaultTranslation(String key, Object ... args) {
        return I18n.get((String)this.defaultTranslations.getOrDefault(key, key), (Object[])args);
    }
}

