/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.mixin;

import com.mojang.datafixers.util.Pair;
import com.structureessentials.StructureEssentials;
import com.structureessentials.config.CommonConfiguration;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public class StructureSearchSpeedupMixin {
    @Inject(method={"getStructureGeneratingAt"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onFind(Set<Holder<Structure>> holderSet, LevelReader level, StructureManager structureManager, boolean load, StructurePlacement placement, ChunkPos pos, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir) {
        if (holderSet.isEmpty() || !((CommonConfiguration)StructureEssentials.config.getCommonConfig()).useFastStructureLookup) {
            return;
        }
        boolean found = false;
        int[] yLevels = Mth.outFromOrigin((int)65, (int)(level.getMinBuildHeight() + 1), (int)level.getMaxBuildHeight(), (int)64).toArray();
        BlockPos worldPos = pos.getWorldPosition();
        block0: for (int i = 0; i < 4; ++i) {
            int xQuart = QuartPos.fromBlock((int)(worldPos.getX() + i * 4));
            int zQuart = QuartPos.fromBlock((int)(worldPos.getZ() + i * 4));
            for (int yBlock : yLevels) {
                int yQuart = QuartPos.fromBlock((int)yBlock);
                Holder holder = ((ServerLevel)level).getChunkSource().getGenerator().getBiomeSource().getNoiseBiome(xQuart, yQuart, zQuart, ((ServerLevel)level).getChunkSource().randomState().sampler());
                for (Holder<Structure> structureHolder : holderSet) {
                    if (!((Structure)structureHolder.value()).biomes().contains(holder)) continue;
                    found = true;
                    break block0;
                }
            }
        }
        if (!found) {
            cir.setReturnValue(null);
        }
    }
}

