/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.real;

import com.google.gson.annotations.Expose;
import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.IResettable;
import fr.rakambda.fallingtree.common.config.IToolConfiguration;
import fr.rakambda.fallingtree.common.config.enums.DamageRounding;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ToolConfiguration
implements IToolConfiguration,
IResettable {
    @Expose
    @NotNull
    private List<String> allowed = new ArrayList<String>();
    @Expose
    @NotNull
    private List<String> denied = new ArrayList<String>();
    @Expose
    private boolean preserve = false;
    @Expose
    private boolean ignoreTools = false;
    @Expose
    private double damageMultiplicand = 1.0;
    @Expose
    @NotNull
    private DamageRounding damageRounding = DamageRounding.ROUND_DOWN;
    @Expose
    private double speedMultiplicand = 0.0;
    @Expose
    private boolean forceToolUsage = false;
    private Set<IItem> deniedCache;
    private Set<IItem> allowedCache;

    @Override
    @NotNull
    public Collection<IItem> getDeniedItems(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.deniedCache)) {
            this.deniedCache = common.getAsItems(this.getDenied());
        }
        return this.deniedCache;
    }

    @Override
    @NotNull
    public Collection<IItem> getAllowedItems(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.allowedCache)) {
            this.allowedCache = common.getAsItems(this.getAllowed());
        }
        return this.allowedCache;
    }

    @Override
    public void reset() {
        this.deniedCache = null;
        this.allowedCache = null;
    }

    @Generated
    public ToolConfiguration() {
    }

    @NotNull
    @Generated
    public List<String> getAllowed() {
        return this.allowed;
    }

    @NotNull
    @Generated
    public List<String> getDenied() {
        return this.denied;
    }

    @Override
    @Generated
    public boolean isPreserve() {
        return this.preserve;
    }

    @Override
    @Generated
    public boolean isIgnoreTools() {
        return this.ignoreTools;
    }

    @Override
    @Generated
    public double getDamageMultiplicand() {
        return this.damageMultiplicand;
    }

    @Override
    @NotNull
    @Generated
    public DamageRounding getDamageRounding() {
        return this.damageRounding;
    }

    @Override
    @Generated
    public double getSpeedMultiplicand() {
        return this.speedMultiplicand;
    }

    @Override
    @Generated
    public boolean isForceToolUsage() {
        return this.forceToolUsage;
    }

    @Generated
    public Set<IItem> getDeniedCache() {
        return this.deniedCache;
    }

    @Generated
    public Set<IItem> getAllowedCache() {
        return this.allowedCache;
    }

    @Generated
    public void setAllowed(@NotNull List<String> allowed) {
        if (allowed == null) {
            throw new NullPointerException("allowed is marked non-null but is null");
        }
        this.allowed = allowed;
    }

    @Generated
    public void setDenied(@NotNull List<String> denied) {
        if (denied == null) {
            throw new NullPointerException("denied is marked non-null but is null");
        }
        this.denied = denied;
    }

    @Generated
    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    @Generated
    public void setIgnoreTools(boolean ignoreTools) {
        this.ignoreTools = ignoreTools;
    }

    @Generated
    public void setDamageMultiplicand(double damageMultiplicand) {
        this.damageMultiplicand = damageMultiplicand;
    }

    @Generated
    public void setDamageRounding(@NotNull DamageRounding damageRounding) {
        if (damageRounding == null) {
            throw new NullPointerException("damageRounding is marked non-null but is null");
        }
        this.damageRounding = damageRounding;
    }

    @Generated
    public void setSpeedMultiplicand(double speedMultiplicand) {
        this.speedMultiplicand = speedMultiplicand;
    }

    @Generated
    public void setForceToolUsage(boolean forceToolUsage) {
        this.forceToolUsage = forceToolUsage;
    }

    @Generated
    public void setDeniedCache(Set<IItem> deniedCache) {
        this.deniedCache = deniedCache;
    }

    @Generated
    public void setAllowedCache(Set<IItem> allowedCache) {
        this.allowedCache = allowedCache;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToolConfiguration)) {
            return false;
        }
        ToolConfiguration other = (ToolConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreserve() != other.isPreserve()) {
            return false;
        }
        if (this.isIgnoreTools() != other.isIgnoreTools()) {
            return false;
        }
        if (Double.compare(this.getDamageMultiplicand(), other.getDamageMultiplicand()) != 0) {
            return false;
        }
        if (Double.compare(this.getSpeedMultiplicand(), other.getSpeedMultiplicand()) != 0) {
            return false;
        }
        if (this.isForceToolUsage() != other.isForceToolUsage()) {
            return false;
        }
        List<String> this$allowed = this.getAllowed();
        List<String> other$allowed = other.getAllowed();
        if (this$allowed == null ? other$allowed != null : !((Object)this$allowed).equals(other$allowed)) {
            return false;
        }
        List<String> this$denied = this.getDenied();
        List<String> other$denied = other.getDenied();
        if (this$denied == null ? other$denied != null : !((Object)this$denied).equals(other$denied)) {
            return false;
        }
        DamageRounding this$damageRounding = this.getDamageRounding();
        DamageRounding other$damageRounding = other.getDamageRounding();
        if (this$damageRounding == null ? other$damageRounding != null : !((Object)((Object)this$damageRounding)).equals((Object)other$damageRounding)) {
            return false;
        }
        Set<IItem> this$deniedCache = this.getDeniedCache();
        Set<IItem> other$deniedCache = other.getDeniedCache();
        if (this$deniedCache == null ? other$deniedCache != null : !((Object)this$deniedCache).equals(other$deniedCache)) {
            return false;
        }
        Set<IItem> this$allowedCache = this.getAllowedCache();
        Set<IItem> other$allowedCache = other.getAllowedCache();
        return !(this$allowedCache == null ? other$allowedCache != null : !((Object)this$allowedCache).equals(other$allowedCache));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ToolConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreserve() ? 79 : 97);
        result = result * 59 + (this.isIgnoreTools() ? 79 : 97);
        long $damageMultiplicand = Double.doubleToLongBits(this.getDamageMultiplicand());
        result = result * 59 + (int)($damageMultiplicand >>> 32 ^ $damageMultiplicand);
        long $speedMultiplicand = Double.doubleToLongBits(this.getSpeedMultiplicand());
        result = result * 59 + (int)($speedMultiplicand >>> 32 ^ $speedMultiplicand);
        result = result * 59 + (this.isForceToolUsage() ? 79 : 97);
        List<String> $allowed = this.getAllowed();
        result = result * 59 + ($allowed == null ? 43 : ((Object)$allowed).hashCode());
        List<String> $denied = this.getDenied();
        result = result * 59 + ($denied == null ? 43 : ((Object)$denied).hashCode());
        DamageRounding $damageRounding = this.getDamageRounding();
        result = result * 59 + ($damageRounding == null ? 43 : ((Object)((Object)$damageRounding)).hashCode());
        Set<IItem> $deniedCache = this.getDeniedCache();
        result = result * 59 + ($deniedCache == null ? 43 : ((Object)$deniedCache).hashCode());
        Set<IItem> $allowedCache = this.getAllowedCache();
        result = result * 59 + ($allowedCache == null ? 43 : ((Object)$allowedCache).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ToolConfiguration(allowed=" + String.valueOf(this.getAllowed()) + ", denied=" + String.valueOf(this.getDenied()) + ", preserve=" + this.isPreserve() + ", ignoreTools=" + this.isIgnoreTools() + ", damageMultiplicand=" + this.getDamageMultiplicand() + ", damageRounding=" + String.valueOf((Object)this.getDamageRounding()) + ", speedMultiplicand=" + this.getSpeedMultiplicand() + ", forceToolUsage=" + this.isForceToolUsage() + ", deniedCache=" + String.valueOf(this.getDeniedCache()) + ", allowedCache=" + String.valueOf(this.getAllowedCache()) + ")";
    }
}

