/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common.wrapper;

import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IChunk;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IRandomSource;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockEntityWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockStateWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ChunkAccessWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.RandomSourceWrapper;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelWrapper
implements ILevel {
    @Generated
    private static final Logger log = LogManager.getLogger(LevelWrapper.class);
    @NotNull
    private final LevelAccessor raw;

    @Override
    public boolean isServer() {
        return !this.raw.isClientSide();
    }

    @Override
    @NotNull
    public IChunk getChunk(@NotNull IBlockPos blockPos) {
        BlockPos pos = (BlockPos)blockPos.getRaw();
        return new ChunkAccessWrapper(this.raw.getChunk(pos));
    }

    @Override
    public boolean hasChunk(int x, int z) {
        return this.raw.hasChunk(x, z);
    }

    @Override
    @NotNull
    public IBlockState getBlockState(@NotNull IBlockPos blockPos) {
        BlockPos pos = (BlockPos)blockPos.getRaw();
        return new BlockStateWrapper(this.raw.getBlockState(pos));
    }

    @Override
    @Nullable
    public IBlockEntity getBlockEntity(@NotNull IBlockPos blockPos) {
        BlockEntity entity = this.raw.getBlockEntity((BlockPos)blockPos.getRaw());
        return entity == null ? null : new BlockEntityWrapper(entity);
    }

    @Override
    @NotNull
    public IRandomSource getRandom() {
        return new RandomSourceWrapper(this.raw.getRandom());
    }

    @Override
    public boolean removeBlock(@NotNull IBlockPos blockPos, boolean b) {
        return this.raw.removeBlock((BlockPos)blockPos.getRaw(), b);
    }

    @Override
    public void fallBlock(@NotNull IBlockPos logBlockPos, boolean drop, double dx, double dy, double dz, double vx, double vy, double vz) {
        FallingBlockEntity entity = this.createFallingEntity(logBlockPos, dx, dy, dz);
        if (!drop) {
            entity.disableDrop();
        }
        entity.setDeltaMovement(vx, vy, vz);
        this.raw.addFreshEntity((Entity)entity);
    }

    @NotNull
    private FallingBlockEntity createFallingEntity(@NotNull IBlockPos logBlockPos, double dx, double dy, double dz) {
        double x = (double)logBlockPos.getX() + dx;
        double y = (double)logBlockPos.getY() + dy;
        double z = (double)logBlockPos.getZ() + dz;
        BlockState blockState = (BlockState)this.getBlockState(logBlockPos).getRaw();
        BlockState newBlockState = blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) : blockState;
        FallingBlockEntity entity = new FallingBlockEntity(EntityType.FALLING_BLOCK, (Level)this.raw);
        entity.blocksBuilding = true;
        entity.setPos(x, y, z);
        entity.xo = x;
        entity.yo = y;
        entity.zo = z;
        entity.blockState = newBlockState;
        return entity;
    }

    @Generated
    public LevelWrapper(@NotNull LevelAccessor raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    @Generated
    public String toString() {
        return "LevelWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @NotNull
    @Generated
    public LevelAccessor getRaw() {
        return this.raw;
    }
}

