/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.common.wrapper;

import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ComponentWrapper;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockWrapper
implements IBlock {
    @NotNull
    private final Block raw;

    @Override
    public boolean isAir() {
        return Blocks.AIR.equals(this.raw);
    }

    @Override
    public void playerDestroy(@NotNull ILevel level, @NotNull IPlayer player, @NotNull IBlockPos blockPos, @NotNull IBlockState blockState, @Nullable IBlockEntity blockEntity, @NotNull IItemStack itemStack) {
        BlockEntity entity = blockEntity == null ? null : (BlockEntity)blockEntity.getRaw();
        this.raw.playerDestroy((Level)level.getRaw(), (Player)player.getRaw(), (BlockPos)blockPos.getRaw(), (BlockState)blockState.getRaw(), entity, (ItemStack)itemStack.getRaw());
    }

    @Override
    @NotNull
    public IComponent getAsComponent() {
        return new ComponentWrapper(this.raw.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IBlock)) {
            return false;
        }
        IBlock block = (IBlock)obj;
        return this.raw.equals(block.getRaw());
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    @Generated
    public BlockWrapper(@NotNull Block raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    @Generated
    public String toString() {
        return "BlockWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @NotNull
    @Generated
    public Block getRaw() {
        return this.raw;
    }
}

