/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.damagesource;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public interface IDeathMessageProvider {
    public static final IDeathMessageProvider DEFAULT = (entity, lastEntry, sigFall) -> {
        DamageSource dmgSrc = lastEntry.source();
        DeathMessageType msgType = dmgSrc.type().deathMessageType();
        if (msgType == DeathMessageType.FALL_VARIANTS && sigFall != null) {
            return entity.getCombatTracker().getFallMessage(sigFall, dmgSrc.getEntity());
        }
        if (msgType == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
            String s = "death.attack." + dmgSrc.getMsgId();
            MutableComponent component = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)(s + ".link"))).withStyle(CombatTracker.INTENTIONAL_GAME_DESIGN_STYLE);
            return Component.translatable((String)(s + ".message"), (Object[])new Object[]{entity.getDisplayName(), component});
        }
        return dmgSrc.getLocalizedDeathMessage(entity);
    };

    public Component getDeathMessage(LivingEntity var1, CombatEntry var2, @Nullable CombatEntry var3);
}

