/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

class DimensionsCommand {
    DimensionsCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dimensions").requires(cs -> cs.hasPermission(0))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.neoforge.dimensions.list"), true);
            Registry reg = ((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
            HashMap<ResourceLocation, List> types = new HashMap<ResourceLocation, List>();
            for (ServerLevel dim : ((CommandSourceStack)ctx.getSource()).getServer().getAllLevels()) {
                types.computeIfAbsent(reg.getKey((Object)dim.dimensionType()), k -> new ArrayList()).add(dim.dimension().location());
            }
            types.keySet().stream().sorted().forEach(key -> ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(String.valueOf(key) + ": " + ((List)types.get(key)).stream().map(ResourceLocation::toString).sorted().collect(Collectors.joining(", ")))), false));
            return 0;
        });
    }
}

