/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.RecipeSorter;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SawmillRecipeGenerator
extends DynServerResourcesGenerator {
    public static final SawmillRecipeGenerator INSTANCE = new SawmillRecipeGenerator(new DynamicDataPack(SawmillMod.res("sawmill_recipes"), Pack.Position.TOP, true, true));

    protected SawmillRecipeGenerator(DynamicDataPack pack) {
        super(pack);
        pack.setGenerateDebugResources(true);
    }

    public Logger getLogger() {
        return SawmillMod.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(ResourceManager resourceManager) {
    }

    public static void process(Collection<RecipeHolder<?>> recipes, ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> byName, ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> byType) {
        List<RecipeHolder<WoodcuttingRecipe>> sawmillRecipes = SawmillRecipeGenerator.process(recipes);
        for (RecipeHolder<WoodcuttingRecipe> r : sawmillRecipes) {
            byName.put((Object)r.id(), r);
            byType.put((Object)((WoodcuttingRecipe)r.value()).getType(), r);
        }
    }

    public static List<RecipeHolder<WoodcuttingRecipe>> process(Collection<RecipeHolder<?>> recipes) {
        if (!CommonConfigs.DYNAMIC_RECIPES.get().booleanValue() && !CommonConfigs.SAVE_RECIPES.get().booleanValue()) {
            return List.of();
        }
        SawmillMod.waitForTags();
        SawmillMod.LOGGER.info("Generating Sawmill Recipes");
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map<Item, Map<WoodType, LogCost>> costs = SawmillRecipeGenerator.createIngredientList(recipes, true);
        int maxWoods = WoodTypeRegistry.getTypes().size();
        Ingredient anyPlanks = Ingredient.of((TagKey)ItemTags.PLANKS);
        Ingredient anyWood = Ingredient.of((TagKey)ItemTags.LOGS);
        ArrayList<RecipeHolder<WoodcuttingRecipe>> sawmillRecipes = new ArrayList<RecipeHolder<WoodcuttingRecipe>>();
        HashMap<WoodType, Ingredient> logIngredients = new HashMap<WoodType, Ingredient>();
        HashMap<WoodType, Ingredient> plankIngredients = new HashMap<WoodType, Ingredient>();
        String group = "logs";
        String group2 = "planks";
        for (Map.Entry<Item, Map<WoodType, LogCost>> entry : costs.entrySet()) {
            Item result = entry.getKey();
            String string = Utils.getID((Item)result).toDebugFileName();
            int counter = 0;
            Map<WoodType, LogCost> logCosts = entry.getValue();
            if (!CommonConfigs.ALLOW_NON_VARIANTS.get().booleanValue() && logCosts.size() != 1) continue;
            if (logCosts.size() == maxWoods) {
                LogCost m = logCosts.get(WoodTypeRegistry.OAK_TYPE);
                SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, anyWood, group, result, string, counter++, m.cost, false);
                SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, anyPlanks, group2, result, string, counter++, SawmillRecipeGenerator.getPlanksCost(WoodTypeRegistry.OAK_TYPE, m), true);
                continue;
            }
            for (LogCost m : logCosts.values()) {
                Ingredient plankInput;
                WoodType woodType = m.type;
                Ingredient logInput = SawmillRecipeGenerator.getOrCreateLogIngredient(logIngredients, woodType);
                if (!logInput.test(result.getDefaultInstance())) {
                    SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, logInput, group, result, string, counter++, m.cost, false);
                }
                if ((plankInput = SawmillRecipeGenerator.getOrCreatePlankIngredient(plankIngredients, woodType)).test(result.getDefaultInstance())) continue;
                SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, plankInput, group2, result, string, counter++, SawmillRecipeGenerator.getPlanksCost(woodType, m), true);
            }
        }
        for (WoodType type : WoodTypeRegistry.getTypes()) {
            int counter = 0;
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "log", "stripped_log");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "log", "stripped_wood");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "log", "wood");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "wood", "log");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "wood", "stripped_wood");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "wood", "stripped_log");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "stripped_wood", "stripped_log");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "stripped_log", "stripped_wood");
        }
        long millis = stopwatch.elapsed().toMillis();
        SawmillMod.LOGGER.info("Generated Sawmill recipes in {} milliseconds", (Object)millis);
        if (millis > 2000L) {
            SawmillMod.LOGGER.warn("Generating Sawmill recipes took a long time. Consider disabling dynamic recipes in the configs and adding them statically via datapack. You can turn on save_recipe configs to help you with that");
        }
        if (millis > 7000L) {
            SawmillMod.LOGGER.error("You might really want to consider above advice...");
        }
        SawmillMod.clearTagHacks();
        if (CommonConfigs.SAVE_RECIPES.get().booleanValue()) {
            for (RecipeHolder recipeHolder : sawmillRecipes) {
                ((DynamicDataPack)SawmillRecipeGenerator.INSTANCE.dynamicPack).addRecipe(recipeHolder);
            }
        }
        if (!CommonConfigs.DYNAMIC_RECIPES.get().booleanValue()) {
            return List.of();
        }
        RecipeSorter.accept(sawmillRecipes);
        return sawmillRecipes;
    }

    private static double getPlanksCost(WoodType type, LogCost m) {
        if (type.getTypeName().equals("bamboo")) {
            return m.cost * 2.0;
        }
        return m.cost * 4.0;
    }

    private static void addLogRecipe(List<RecipeHolder<WoodcuttingRecipe>> sawmillRecipes, WoodType type, int counter, String from, String to) {
        Item fromLog = type.getItemOfThis(from);
        Item toLog = type.getItemOfThis(to);
        if (fromLog != null && toLog != null) {
            SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, Ingredient.of((ItemLike[])new ItemLike[]{fromLog}), "log", toLog, type.getAppendableId() + "_log", counter, 1.0, true);
        }
    }

    private static void addNewRecipe(List<RecipeHolder<WoodcuttingRecipe>> sawmillRecipes, Ingredient input, String group, Item result, String itemId, int counter, double cost, boolean only1on1) {
        int maxStackSize = (Integer)result.components().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1);
        InputOutputCost resCost = SawmillRecipeGenerator.getInputOutputCost(cost, maxStackSize);
        int inputCount = resCost.inputCount();
        int outputCount = resCost.outputCount();
        if (only1on1 && inputCount != 1 && CommonConfigs.PLANKS_ONLY_ONE.get().booleanValue()) {
            return;
        }
        if (outputCount > 0) {
            if (!only1on1) {
                // empty if block
            }
            ResourceLocation res = SawmillMod.res(itemId + "_" + counter);
            WoodcuttingRecipe recipe = new WoodcuttingRecipe(group, input, new ItemStack((ItemLike)result, outputCount), inputCount);
            sawmillRecipes.add((RecipeHolder<WoodcuttingRecipe>)new RecipeHolder(res, (Recipe)recipe));
        }
    }

    @NotNull
    private static InputOutputCost getInputOutputCost(double cost, int maxOutputCount) {
        int inputCount = 1;
        int outputCount = 0;
        double maxDiscount = CommonConfigs.MAX_DISCOUNT.get();
        if (cost > 1.0 + maxDiscount) {
            return new InputOutputCost((int)cost, 1);
        }
        double preciseOutputCount = 1.0 / cost;
        double discountedOutput = 1.0 / (cost /= 1.0 + maxDiscount);
        double considerDiscountThreshold = 0.25;
        if ((outputCount = (int)((long)outputCount + Math.round(preciseOutputCount % 1.0 > considerDiscountThreshold ? (preciseOutputCount + discountedOutput) / 2.0 : preciseOutputCount))) > maxOutputCount) {
            double ratio = (double)maxOutputCount / (double)outputCount;
            outputCount = maxOutputCount;
            inputCount = Mth.ceil((double)((double)inputCount * ratio));
        }
        return new InputOutputCost(inputCount, outputCount);
    }

    private static Ingredient getOrCreatePlankIngredient(Map<WoodType, Ingredient> cache, WoodType type) {
        return cache.computeIfAbsent(type, t -> {
            List<Item> children = SawmillRecipeGenerator.getAllChildren(type, "planks", "quark:vertical_planks");
            return Ingredient.of((ItemLike[])((ItemLike[])children.toArray(Item[]::new)));
        });
    }

    private static Ingredient getOrCreateLogIngredient(Map<WoodType, Ingredient> cache, WoodType type) {
        return cache.computeIfAbsent(type, t -> {
            if (t.getTypeName().equals("archwood")) {
                return Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:logs/archwood")));
            }
            List<Item> children = SawmillRecipeGenerator.getAllChildren(type, "log", "wood", "stripped_log", "stripped_wood");
            return Ingredient.of((ItemLike[])((ItemLike[])children.toArray(Item[]::new)));
        });
    }

    private static Map<Item, Map<WoodType, LogCost>> createIngredientList(Collection<RecipeHolder<?>> recipes, boolean optim) {
        HashMap<Item, Map<WoodType, LogCost>> itemToPrimitiveCost = new HashMap<Item, Map<WoodType, LogCost>>();
        for (WoodType type : WoodTypeRegistry.getTypes()) {
            Map<WoodType, LogCost> logCostInLog = Map.of(type, LogCost.of(type, 1.0));
            List<Item> children = SawmillRecipeGenerator.getAllChildren(type, "log", "wood", "stripped_log", "stripped_wood");
            children.forEach(item -> itemToPrimitiveCost.put((Item)item, logCostInLog));
            itemToPrimitiveCost.computeIfAbsent(Items.STICK, s -> new HashMap()).put(type, LogCost.of(type, 0.125));
        }
        SawmillRecipeGenerator.addHardcodedCosts(itemToPrimitiveCost);
        HashSet validRecipes = new HashSet();
        HashSet<Item> craftableItems = new HashSet<Item>();
        boolean allowNonBlocks = CommonConfigs.ALLOW_NON_BLOCKS.get();
        for (RecipeHolder<?> recipe : recipes) {
            if (!SawmillMod.isWhitelisted(recipe)) continue;
            try {
                Recipe recipe2 = recipe.value();
                Item i = recipe2.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem();
                if (!allowNonBlocks && !(i instanceof BlockItem)) continue;
                if (!recipe2.getIngredients().isEmpty()) {
                    craftableItems.add(i);
                    validRecipes.add(recipe2);
                    continue;
                }
                boolean bl = true;
            }
            catch (Exception exception) {}
        }
        if (optim) {
            SawmillRecipeGenerator.removeUnNeded(itemToPrimitiveCost, validRecipes, craftableItems);
        }
        craftableItems.clear();
        HashMultimap itemsToRecipe = HashMultimap.create();
        for (Recipe recipe : validRecipes) {
            Item res = recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem();
            itemsToRecipe.put((Object)res, (Object)recipe);
            craftableItems.add(res);
        }
        for (Item item2 : craftableItems) {
            SawmillRecipeGenerator.getPrimitiveCostRecursive(item2, itemsToRecipe, itemToPrimitiveCost, new HashSet());
        }
        itemToPrimitiveCost.values().removeIf(Objects::isNull);
        return itemToPrimitiveCost;
    }

    private static void addHardcodedCosts(Map<Item, Map<WoodType, LogCost>> itemToPrimitiveCost) {
        HashMap<String, Double> specialCosts = new HashMap<String, Double>(CommonConfigs.SPECIAL_COSTS.get());
        Iterator iter = specialCosts.entrySet().iterator();
        while (iter.hasNext()) {
            Optional opt;
            Map.Entry c = iter.next();
            String id = (String)c.getKey();
            double costInLogs = (Double)c.getValue() / 4.0;
            boolean hasWood = false;
            for (WoodType type2 : WoodTypeRegistry.getTypes()) {
                Item woodItem = type2.getItemOfThis(id);
                if (woodItem == null) continue;
                Map<WoodType, LogCost> stairsCostInLog = Map.of(type2, LogCost.of(type2, costInLogs));
                itemToPrimitiveCost.put(woodItem, stairsCostInLog);
                hasWood = true;
            }
            if (!hasWood && (opt = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)id))).isPresent()) {
                Map cost = WoodTypeRegistry.getTypes().stream().collect(Collectors.toMap(Function.identity(), type -> LogCost.of(type, costInLogs)));
                itemToPrimitiveCost.put((Item)opt.get(), cost);
            }
            iter.remove();
        }
    }

    private static void removeUnNeded(Map<Item, Map<WoodType, LogCost>> itemToPrimitiveCost, Set<Recipe<?>> validRecipes, Set<Item> craftableItems) {
        Iterator<Recipe<?>> iterator = validRecipes.iterator();
        block0: while (iterator.hasNext()) {
            Recipe<?> recipe = iterator.next();
            for (Ingredient ing : recipe.getIngredients()) {
                if (ing.isEmpty()) continue;
                boolean atLeastOneCorrect = false;
                for (ItemStack alternative : SawmillRecipeGenerator.getIngItems(ing)) {
                    Item a = alternative.getItem();
                    if (!itemToPrimitiveCost.containsKey(a) && !craftableItems.contains(a)) continue;
                    atLeastOneCorrect = true;
                }
                if (atLeastOneCorrect) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    @NotNull
    private static ItemStack[] getIngItems(Ingredient ing) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        boolean isTag = false;
        boolean isVanilla = SawmillMod.isVanillaIngredient(ing);
        if (!isVanilla && CommonConfigs.IGNORE_CUSTOM_INGREDIENTS.get().booleanValue()) {
            return new ItemStack[0];
        }
        if (isVanilla) {
            for (Ingredient.Value v : ing.values) {
                if (!(v instanceof Ingredient.TagValue)) continue;
                Ingredient.TagValue tv = (Ingredient.TagValue)v;
                isTag = true;
                TagKey tag = tv.tag;
                stacks.addAll(SawmillMod.getTagElements((TagKey<Item>)tag));
            }
        }
        if (!isTag) {
            return ing.getItems();
        }
        return (ItemStack[])stacks.toArray(ItemStack[]::new);
    }

    private static List<Item> getAllChildren(WoodType type, String ... keys) {
        ArrayList<Item> children = new ArrayList<Item>();
        for (String k : keys) {
            Object child = type.getChild(k);
            if (!(child instanceof ItemLike)) continue;
            ItemLike il = (ItemLike)child;
            children.add(il.asItem());
        }
        return children;
    }

    @Nullable
    public static Map<WoodType, LogCost> getPrimitiveCostRecursive(Item itemToUncraft, Multimap<Item, Recipe<?>> allRecipes, Map<Item, Map<WoodType, LogCost>> cache, Set<Recipe<?>> visitedRecipes) {
        Map<WoodType, LogCost> cached = cache.get(itemToUncraft);
        if (cached != null) {
            return cached;
        }
        ArrayList<Map<WoodType, LogCost>> possibleCosts = new ArrayList<Map<WoodType, LogCost>>();
        Collection possibleRecipes = allRecipes.get((Object)itemToUncraft);
        block0: for (Recipe recipe : possibleRecipes) {
            if (visitedRecipes.contains(recipe)) continue;
            visitedRecipes.add(recipe);
            HashMap recipeCostPerWood = new HashMap();
            for (Ingredient ingredient : recipe.getIngredients()) {
                if (ingredient.isEmpty()) continue;
                HashMap ingredientPossibleCosts = new HashMap();
                for (ItemStack ing : SawmillRecipeGenerator.getIngItems(ingredient)) {
                    Map<WoodType, LogCost> itemCost = SawmillRecipeGenerator.getPrimitiveCostRecursive(ing.getItem(), allRecipes, cache, visitedRecipes);
                    if (itemCost == null) continue;
                    itemCost.forEach((woodType, logCost) -> ingredientPossibleCosts.merge(woodType, logCost, LogCost::min));
                }
                if (ingredientPossibleCosts.isEmpty()) continue block0;
                if (recipeCostPerWood.isEmpty()) {
                    recipeCostPerWood.putAll(ingredientPossibleCosts);
                    continue;
                }
                recipeCostPerWood.keySet().retainAll(ingredientPossibleCosts.keySet());
                if (recipeCostPerWood.isEmpty()) continue block0;
                recipeCostPerWood.forEach((key, val) -> recipeCostPerWood.merge(key, (LogCost)ingredientPossibleCosts.get(key), LogCost::sum));
            }
            int outputCount = recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getCount();
            recipeCostPerWood.replaceAll((woodType, logCost) -> logCost.divide(outputCount));
            possibleCosts.add(recipeCostPerWood);
        }
        Map<WoodType, LogCost> ret = null;
        if (!possibleCosts.isEmpty()) {
            ret = SawmillRecipeGenerator.chooseMinCost(possibleCosts);
        }
        cache.put(itemToUncraft, ret);
        return ret;
    }

    public static Map<WoodType, LogCost> chooseMinCost(List<Map<WoodType, LogCost>> possibleRecipeCosts) {
        HashMap<WoodType, LogCost> result = new HashMap<WoodType, LogCost>();
        for (Map<WoodType, LogCost> map : possibleRecipeCosts) {
            for (Map.Entry<WoodType, LogCost> entry : map.entrySet()) {
                WoodType key = entry.getKey();
                LogCost value = entry.getValue();
                result.merge(key, value, LogCost::min);
            }
        }
        return result;
    }

    private record LogCost(WoodType type, Double cost) {
        static LogCost of(WoodType type, Double amount) {
            return new LogCost(type, amount);
        }

        public LogCost sum(LogCost logCost) {
            return new LogCost(this.type, logCost.cost + this.cost);
        }

        public LogCost divide(double outputCount) {
            return new LogCost(this.type, this.cost / outputCount);
        }

        public static LogCost min(LogCost first, LogCost second) {
            return first.cost < second.cost ? first : second;
        }
    }

    private record InputOutputCost(int inputCount, int outputCount) {
    }
}

