/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.integration.emi;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.mehvahdjukaar.sawmill.integration.emi.EMIPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class EmiWoodcuttingRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient input;
    private final EmiStack output;
    private final int inputCount;

    public EmiWoodcuttingRecipe(WoodcuttingRecipe recipe) {
        this.id = EmiPort.getId((Recipe)recipe);
        this.input = EmiIngredient.of((Ingredient)((Ingredient)recipe.getIngredients().get(0)));
        this.output = EmiStack.of((ItemStack)EmiPort.getOutput((Recipe)recipe));
        this.inputCount = recipe.getInputCount();
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.WOODCUTTING_CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 76;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 26, 1);
        widgets.addSlot(this.input, 0, 0);
        widgets.add(new Widget(){
            private final Bounds bounds = new Bounds(0, 0, 18, 18);

            public Bounds getBounds() {
                return this.bounds;
            }

            public void render(GuiGraphics guiGraphics, int i, int i1, float v) {
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, new ItemStack((ItemLike)Items.DIRT, EmiWoodcuttingRecipe.this.inputCount), 0, 0);
            }
        });
        widgets.addSlot((EmiIngredient)this.output, 58, 0).recipeContext((EmiRecipe)this);
    }
}

