/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.Utils;

public final class ShapeUtils {
    private static final Direction[] HORIZONTAL_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().toArray(Direction[]::new);
    private static final int[] DIR_ROT_X_2D_DATA = (int[])Util.make((Object)new int[6], arr -> {
        arr[Direction.DOWN.ordinal()] = 2;
        arr[Direction.UP.ordinal()] = 0;
        arr[Direction.NORTH.ordinal()] = 3;
        arr[Direction.SOUTH.ordinal()] = 1;
        arr[Direction.WEST.ordinal()] = -1;
        arr[Direction.EAST.ordinal()] = -1;
    });
    private static final int[] DIR_ROT_Z_2D_DATA = (int[])Util.make((Object)new int[6], arr -> {
        arr[Direction.DOWN.ordinal()] = 2;
        arr[Direction.UP.ordinal()] = 0;
        arr[Direction.NORTH.ordinal()] = -1;
        arr[Direction.SOUTH.ordinal()] = -1;
        arr[Direction.WEST.ordinal()] = 3;
        arr[Direction.EAST.ordinal()] = 1;
    });

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.joinUnoptimized((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.OR);
    }

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.orUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape or(VoxelShape first, VoxelShape second) {
        return ShapeUtils.orUnoptimized(first, second).optimize();
    }

    public static VoxelShape or(VoxelShape first, VoxelShape ... others) {
        return ShapeUtils.orUnoptimized(first, others).optimize();
    }

    public static VoxelShape andUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.joinUnoptimized((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.AND);
    }

    public static VoxelShape andUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.andUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape and(VoxelShape first, VoxelShape second) {
        return ShapeUtils.andUnoptimized(first, second).optimize();
    }

    public static VoxelShape and(VoxelShape first, VoxelShape ... others) {
        return ShapeUtils.andUnoptimized(first, others).optimize();
    }

    public static VoxelShape rotateShapeAroundY(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimizedAroundY(from, to, shape).optimize();
    }

    public static VoxelShape rotateShapeUnoptimizedAroundY(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isY(from) || Utils.isY(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(1.0 - box.maxZ, box.minY, box.minX, 1.0 - box.minZ, box.maxY, box.maxX);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateShapeAroundX(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimizedAroundX(from, to, shape).optimize();
    }

    public static VoxelShape rotateShapeUnoptimizedAroundX(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isX(from) || Utils.isX(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        int times = (DIR_ROT_X_2D_DATA[to.ordinal()] - DIR_ROT_X_2D_DATA[from.ordinal()] + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(box.minX, 1.0 - box.maxZ, box.minY, box.maxX, 1.0 - box.minZ, box.maxY);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateShapeAroundZ(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimizedAroundZ(from, to, shape).optimize();
    }

    public static VoxelShape rotateShapeUnoptimizedAroundZ(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isZ(from) || Utils.isZ(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        int times = (DIR_ROT_Z_2D_DATA[to.ordinal()] - DIR_ROT_Z_2D_DATA[from.ordinal()] + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(box.minY, 1.0 - box.maxX, box.minZ, box.maxY, 1.0 - box.minX, box.maxZ);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static void makeHorizontalRotations(VoxelShape shape, Direction srcDir, VoxelShape[] out, int baseOffset) {
        if (Utils.isY(srcDir)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        for (int i = 0; i < 4; ++i) {
            boolean baseShape = i == srcDir.get2DDataValue();
            out[baseOffset + i] = baseShape ? shape : Shapes.empty();
        }
        List sourceBoxes = shape.toAabbs();
        for (AABB box : sourceBoxes) {
            for (int i = 1; i < 4; ++i) {
                int idx = baseOffset + (srcDir.get2DDataValue() + i) % 4;
                box = new AABB(1.0 - box.maxZ, box.minY, box.minX, 1.0 - box.minZ, box.maxY, box.maxX);
                out[idx] = ShapeUtils.orUnoptimized(out[idx], Shapes.create((AABB)box));
            }
        }
        for (int i = 0; i < 4; ++i) {
            out[baseOffset + i] = out[baseOffset + i].optimize();
        }
    }

    public static VoxelShape[] makeHorizontalRotations(VoxelShape shape, Direction srcDir) {
        VoxelShape[] shapes = new VoxelShape[4];
        ShapeUtils.makeHorizontalRotations(shape, srcDir, shapes, 0);
        return shapes;
    }

    public static void makeHorizontalRotations(VoxelShape shape, Direction srcDir, Map<Direction, VoxelShape> targetMap) {
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotations(shape, srcDir);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(dir, shapes[dir.get2DDataValue()]);
        }
    }

    public static <V, T> void makeHorizontalRotations(VoxelShape shape, Direction srcDir, Map<T, VoxelShape> targetMap, V staticKeyParam, ArbKeyGenerator<V, T> keyGen) {
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotations(shape, srcDir);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(keyGen.makeKey(dir, staticKeyParam), shapes[dir.get2DDataValue()]);
        }
    }

    public static <V> void makeHorizontalRotations(VoxelShape shape, Direction srcDir, VoxelShape[] shapes, V staticKeyParam, ArbIndexGenerator<V> keyGen) {
        VoxelShape[] preShapes = ShapeUtils.makeHorizontalRotations(shape, srcDir);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            shapes[keyGen.makeKey((Direction)dir, staticKeyParam)] = preShapes[dir.get2DDataValue()];
        }
    }

    public static VoxelShape[] makeHorizontalRotationsWithFlag(VoxelShape shapeFalse, VoxelShape shapeTrue, Direction srcDir) {
        VoxelShape[] shapes = new VoxelShape[8];
        ShapeUtils.makeHorizontalRotations(shapeFalse, srcDir, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeTrue, srcDir, shapes, 4);
        return shapes;
    }

    public static <T> void makeHorizontalRotationsWithFlag(VoxelShape shapeFalse, VoxelShape shapeTrue, Direction srcDir, Map<T, VoxelShape> targetMap, FlagKeyGenerator<T> keyGen) {
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeFalse, shapeTrue, srcDir);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(keyGen.makeKey(dir, false), shapes[dir.get2DDataValue()]);
            targetMap.put(keyGen.makeKey(dir, true), shapes[dir.get2DDataValue() + 4]);
        }
    }

    public static void makeHorizontalRotationsWithFlag(VoxelShape shapeFalse, VoxelShape shapeTrue, Direction srcDir, VoxelShape[] shapes, FlagIndexGenerator keyGen) {
        VoxelShape[] preShapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeFalse, shapeTrue, srcDir);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            shapes[keyGen.makeKey((Direction)dir, (boolean)false)] = preShapes[dir.get2DDataValue()];
            shapes[keyGen.makeKey((Direction)dir, (boolean)true)] = preShapes[dir.get2DDataValue() + 4];
        }
    }

    private ShapeUtils() {
    }

    public static interface ArbKeyGenerator<V, T> {
        public T makeKey(Direction var1, V var2);
    }

    public static interface ArbIndexGenerator<V> {
        public int makeKey(Direction var1, V var2);
    }

    public static interface FlagKeyGenerator<T> {
        public T makeKey(Direction var1, boolean var2);
    }

    public static interface FlagIndexGenerator {
        public int makeKey(Direction var1, boolean var2);
    }
}

