/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.Utils;

public final class CamoList
implements Iterable<CamoContainer<?, ?>> {
    public static final Codec<CamoList> CODEC = CamoContainerHelper.CODEC.listOf().xmap(CamoList::new, list -> list.camos);
    public static final StreamCodec<RegistryFriendlyByteBuf, CamoList> STREAM_CODEC = CamoContainerHelper.STREAM_CODEC.apply(ByteBufCodecs.list()).map(CamoList::new, list -> list.camos);
    public static final CamoList EMPTY = new CamoList(List.of());
    private final List<CamoContainer<?, ?>> camos;

    private CamoList(List<CamoContainer<?, ?>> camos) {
        this.camos = camos;
    }

    public CamoContainer<?, ?> getCamo(int index) {
        if (this.camos.size() > index) {
            return this.camos.get(index);
        }
        return EmptyCamoContainer.EMPTY;
    }

    public boolean isEmpty() {
        return this.camos.isEmpty();
    }

    public CamoList concat(CamoList other) {
        return new CamoList(Utils.concat(this.camos, other.camos));
    }

    @Override
    public Iterator<CamoContainer<?, ?>> iterator() {
        return this.camos.iterator();
    }

    @Override
    public Spliterator<CamoContainer<?, ?>> spliterator() {
        return this.camos.spliterator();
    }

    public Stream<CamoContainer<?, ?>> stream() {
        return this.camos.stream();
    }

    public CamoList reversed() {
        return new CamoList((List<CamoContainer<?, ?>>)this.camos.reversed());
    }

    public CamoList subList(int fromIndex, int toIndex) {
        if (fromIndex >= this.camos.size()) {
            return EMPTY;
        }
        return new CamoList(this.camos.subList(fromIndex, Math.min(toIndex, this.camos.size())));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.camos, ((CamoList)obj).camos);
    }

    public int hashCode() {
        return Objects.hashCode(this.camos);
    }

    public String toString() {
        return this.camos.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public static CamoList of(CamoContainer<?, ?> camo) {
        return new CamoList(List.of(camo));
    }

    public static CamoList of(CamoContainer<?, ?> ... camos) {
        return new CamoList(List.of(camos));
    }

    public static CamoList of(List<CamoContainer<?, ?>> camos) {
        return new CamoList(List.copyOf(camos));
    }
}

