/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.cube.FramedChestGeometry;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.LatchType;

public class FramedChestLidGeometry
extends Geometry {
    private final BlockState state;
    private final BakedModel baseModel;
    private final Direction facing;
    private final LatchType latch;
    private final ChunkRenderTypeSet addLayers;

    public FramedChestLidGeometry(GeometryFactory.Context ctx) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.latch = (LatchType)((Object)ctx.state().getValue(PropertyHolder.LATCH_TYPE));
        this.addLayers = this.latch == LatchType.DEFAULT ? ModelUtils.CUTOUT : ChunkRenderTypeSet.none();
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quad.getDirection())) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.0625f, 0.0625f, 0.9375f, 0.9375f)).apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.875f : 0.4375f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.0625f, 0.5625f, 0.9375f, 0.875f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        }
        if (this.latch == LatchType.CAMO) {
            FramedChestGeometry.makeChestLatch(quadMap, quad, this.facing);
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return this.addLayers;
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType layer) {
        List quads = this.baseModel.getQuads(this.state, null, rand, data, layer);
        for (BakedQuad quad : quads) {
            quadMap.get(null).add(quad);
        }
    }
}

