/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.ArrayList;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.cube.FramedCubeGeometry;
import xfacthd.framedblocks.common.config.ClientConfig;

public class FramedMarkedCubeGeometry
extends FramedCubeGeometry {
    public static final ModelResourceLocation SLIME_FRAME_LOCATION = ModelResourceLocation.standalone((ResourceLocation)Utils.rl("block/slime_frame"));
    public static final ModelResourceLocation REDSTONE_FRAME_LOCATION = ModelResourceLocation.standalone((ResourceLocation)Utils.rl("block/redstone_frame"));
    private final BlockState state;
    private final BakedModel frameModel;

    private FramedMarkedCubeGeometry(GeometryFactory.Context ctx, ModelResourceLocation frameLocation) {
        super(ctx);
        this.state = ctx.state();
        this.frameModel = ctx.modelLookup().get(frameLocation);
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        FramedBlockData fbData = (FramedBlockData)extraData.get(FramedBlockData.PROPERTY);
        if (fbData != null && !fbData.getCamoContent().isEmpty()) {
            return ModelUtils.CUTOUT;
        }
        return ChunkRenderTypeSet.none();
    }

    @Override
    public void getAdditionalQuads(ArrayList<BakedQuad> quads, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        if (fbData != null && !fbData.getCamoContent().isEmpty()) {
            Utils.copyAll(this.frameModel.getQuads(this.state, side, rand, data, renderType), quads);
        }
    }

    public static FramedCubeGeometry slime(GeometryFactory.Context ctx) {
        if (ClientConfig.VIEW.showSpecialCubeOverlay()) {
            return new FramedMarkedCubeGeometry(ctx, SLIME_FRAME_LOCATION);
        }
        return new FramedCubeGeometry(ctx);
    }

    public static FramedCubeGeometry redstone(GeometryFactory.Context ctx) {
        if (ClientConfig.VIEW.showSpecialCubeOverlay()) {
            return new FramedMarkedCubeGeometry(ctx, REDSTONE_FRAME_LOCATION);
        }
        return new FramedCubeGeometry(ctx);
    }
}

