/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedSlopeGeometry
extends Geometry {
    private final Direction dir;
    private final SlopeType type;
    private final boolean ySlope;

    public FramedSlopeGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.type = (SlopeType)((Object)ctx.state().getValue(PropertyHolder.SLOPE_TYPE));
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.type == SlopeType.HORIZONTAL) {
            if (quad.getDirection() == this.dir.getOpposite()) {
                QuadModifier.of(quad).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).export(quadMap.get(null));
            } else if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 1.0f, 0.0f)).export(quadMap.get(quadDir));
            }
        } else {
            boolean top;
            boolean bl = top = this.type == SlopeType.TOP;
            if (!this.ySlope && quadDir == this.dir.getOpposite()) {
                QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
            } else if (this.ySlope && Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).export(quadMap.get(null));
            } else if (quadDir == this.dir.getClockWise() || quadDir == this.dir.getCounterClockWise()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
            }
        }
    }
}

