/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.modelwrapping;

import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.ModelFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.modelwrapping.ModelWrappingHandler;
import xfacthd.framedblocks.client.modelwrapping.ModelWrappingManager;
import xfacthd.framedblocks.client.modelwrapping.StateLocationCache;

public final class CopyingModelFactory
implements ModelFactory {
    private final Holder<Block> srcBlock;
    private final Lazy<ModelWrappingHandler> sourceWrapper;

    public CopyingModelFactory(Holder<Block> srcBlock) {
        this.srcBlock = srcBlock;
        this.sourceWrapper = Lazy.of(() -> ModelWrappingManager.getHandler((Block)srcBlock.value()));
    }

    @Override
    public BakedModel create(GeometryFactory.Context ctx) {
        BlockState state = ctx.state();
        BlockState srcState = ((Block)this.srcBlock.value()).defaultBlockState();
        for (Property prop : state.getProperties()) {
            if (!srcState.hasProperty(prop)) continue;
            srcState = (BlockState)srcState.setValue(prop, state.getValue(prop));
        }
        ModelResourceLocation baseLoc = StateLocationCache.getLocationFromState(srcState, Utils.getKeyOrThrow(this.srcBlock).location());
        BakedModel baseModel = ctx.modelLookup().get(baseLoc);
        return ((ModelWrappingHandler)this.sourceWrapper.get()).wrapBlockModel(baseModel, srcState, ctx.modelLookup(), ctx.textureLookup(), null);
    }
}

