/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.modelwrapping;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.ModelFactory;
import xfacthd.framedblocks.api.model.wrapping.ModelLookup;
import xfacthd.framedblocks.api.model.wrapping.TextureLookup;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.modelwrapping.ModelCounter;
import xfacthd.framedblocks.client.modelwrapping.StateLocationCache;

public final class ModelWrappingHandler {
    private final Map<BlockState, BakedModel> visitedStates = new IdentityHashMap<BlockState, BakedModel>();
    private final Holder<Block> block;
    private final ModelFactory blockModelFactory;
    private final StateMerger stateMerger;
    @Nullable
    private BlockState itemModelSource;

    public ModelWrappingHandler(Holder<Block> block, ModelFactory blockModelFactory, StateMerger stateMerger) {
        this.block = block;
        this.blockModelFactory = blockModelFactory;
        this.stateMerger = stateMerger;
        this.updateItemModelSource();
    }

    public synchronized BakedModel wrapBlockModel(BakedModel srcModel, BlockState state, ModelLookup modelLookup, TextureLookup textureLookup, @Nullable ModelCounter counter) {
        BlockState mergedState = this.stateMerger.apply(state);
        if (counter != null) {
            counter.increment(mergedState == state);
        }
        return this.visitedStates.computeIfAbsent(mergedState, keyState -> this.blockModelFactory.create(new GeometryFactory.Context((BlockState)keyState, srcModel, modelLookup, textureLookup)));
    }

    public synchronized BakedModel replaceItemModel(ModelLookup modelLookup, TextureLookup textureLookup, @Nullable ModelCounter counter) {
        if (this.itemModelSource == null) {
            ResourceLocation key = Utils.getKeyOrThrow(this.block).location();
            throw new IllegalStateException("ModelWrappingHandler for block '" + String.valueOf(key) + "' does not support item model wrapping");
        }
        BakedModel model = this.visitedStates.get(this.itemModelSource);
        if (model == null) {
            BakedModel srcModel = modelLookup.get(StateLocationCache.getLocationFromState(this.itemModelSource, null));
            model = this.wrapBlockModel(srcModel, this.itemModelSource, modelLookup, textureLookup, null);
        }
        if (counter != null) {
            counter.incrementItem();
        }
        return model;
    }

    private void updateItemModelSource() {
        IFramedBlock framedBlock;
        BlockState itemSource = null;
        Object object = this.block.value();
        if (object instanceof IFramedBlock && (itemSource = (framedBlock = (IFramedBlock)object).getItemModelSource()) != null && !itemSource.is(this.block)) {
            throw new IllegalArgumentException("Item model source '" + String.valueOf(itemSource) + "' is invalid for block '" + String.valueOf(this.block.value()) + "'");
        }
        this.itemModelSource = itemSource;
    }

    public Block getBlock() {
        return (Block)this.block.value();
    }

    public synchronized void reset() {
        this.visitedStates.clear();
        this.blockModelFactory.reset();
        this.updateItemModelSource();
    }

    public boolean handlesItemModel() {
        return this.itemModelSource != null;
    }

    public StateMerger getStateMerger() {
        return this.stateMerger;
    }

    public int getVisitedStateCount() {
        return this.visitedStates.size();
    }
}

