/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.TextureLookup;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.cube.FramedChestLidGeometry;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.FramedChestBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;
import xfacthd.framedblocks.common.data.property.LatchType;

public class FramedChestRenderer
implements BlockEntityRenderer<FramedChestBlockEntity> {
    private static final Table<Direction, LatchType, BakedModel> LID_MODELS = HashBasedTable.create((int)4, (int)3);
    private static final RandomSource RANDOM = RandomSource.create();

    public FramedChestRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FramedChestBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        float xOff;
        BlockState state = be.getBlockState();
        ChestState chestState = (ChestState)((Object)state.getValue(PropertyHolder.CHEST_STATE));
        if (chestState == ChestState.CLOSED) {
            return;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        long lastChange = be.getLastChangeTime(chestState);
        BakedModel model = (BakedModel)LID_MODELS.get((Object)dir, (Object)state.getValue(PropertyHolder.LATCH_TYPE));
        ModelData data = model.getModelData((BlockAndTintGetter)be.getLevel(), be.getBlockPos(), state, be.getModelData());
        float angle = FramedChestRenderer.calculateAngle(be, chestState, dir, lastChange, partialTicks);
        float f = Utils.isX(dir) ? (Utils.isPositive(dir) ? 0.0625f : 0.9375f) : (xOff = 0.0f);
        float zOff = Utils.isZ(dir) ? (Utils.isPositive(dir) ? 0.0625f : 0.9375f) : 0.0f;
        poseStack.pushPose();
        poseStack.translate(xOff, 0.5625f, zOff);
        poseStack.mulPose(Utils.isX(dir) ? Axis.ZP.rotationDegrees(angle) : Axis.XN.rotationDegrees(angle));
        poseStack.translate(-xOff, -0.5625f, -zOff);
        FramedChestRenderer.renderLidModel(be, state, poseStack, buffer, model, data);
        poseStack.popPose();
    }

    private static void renderLidModel(FramedChestBlockEntity be, BlockState state, PoseStack matrix, MultiBufferSource buffer, BakedModel model, ModelData data) {
        ModelBlockRenderer renderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
        int color = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)be.getLevel(), be.getBlockPos(), 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)be.getBlockPos());
        RANDOM.setSeed(42L);
        for (RenderType type : model.getRenderTypes(state, RANDOM, data)) {
            RenderType bufferType = RenderTypeHelper.getEntityRenderType((RenderType)type, (boolean)false);
            renderer.renderModel(matrix.last(), buffer.getBuffer(bufferType), state, model, red, green, blue, light, OverlayTexture.NO_OVERLAY, data, type);
        }
    }

    private static float calculateAngle(FramedChestBlockEntity be, ChestState chestState, Direction dir, long lastChange, float partialTicks) {
        float diff = (float)(be.getLevel().getGameTime() - lastChange) + partialTicks;
        float factor = Mth.lerp((float)(diff / 10.0f), (float)0.0f, (float)1.0f);
        if (chestState == ChestState.CLOSING) {
            factor = 1.0f - factor;
        }
        factor = 1.0f - factor;
        factor = 1.0f - factor * factor * factor;
        float angle = Mth.clamp((float)(factor * 90.0f), (float)0.0f, (float)90.0f);
        if (!Utils.isPositive(dir)) {
            angle *= -1.0f;
        }
        return angle;
    }

    public boolean shouldRender(FramedChestBlockEntity be, Vec3 camera) {
        return ClientUtils.OPTIFINE_LOADED.get() == false && be.getBlockState().getValue(PropertyHolder.CHEST_STATE) != ChestState.CLOSED && super.shouldRender((BlockEntity)be, camera);
    }

    public AABB getRenderBoundingBox(FramedChestBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 0.25, (double)pos.getY() + 0.5625, (double)pos.getZ() - 0.25, (double)pos.getX() + 1.25, (double)pos.getY() + 1.5, (double)pos.getZ() + 1.25);
    }

    public static void onModelsLoaded(Map<ModelResourceLocation, BakedModel> registry) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            for (LatchType latch : LatchType.values()) {
                BlockState state = (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_CHEST.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue(PropertyHolder.LATCH_TYPE, (Comparable)((Object)latch));
                ModelResourceLocation location = BlockModelShaper.stateToModelLocation((BlockState)state);
                BakedModel model = registry.get(location);
                if (model instanceof FramedBlockModel) {
                    FramedBlockModel fbModel = (FramedBlockModel)model;
                    model = fbModel.getBaseModel();
                }
                GeometryFactory.Context ctx = new GeometryFactory.Context(state, model, registry::get, TextureLookup.runtime());
                LID_MODELS.put((Object)dir, (Object)latch, (Object)new FramedBlockModel(ctx, new FramedChestLidGeometry(ctx)));
            }
        }
    }
}

