/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.camo.block.BlockCamoContent;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.quad.QuadData;
import xfacthd.framedblocks.api.render.debug.BlockDebugRenderer;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.config.DevToolsConfig;

public class QuadWindingDebugRenderer
implements BlockDebugRenderer<FramedBlockEntity> {
    public static final QuadWindingDebugRenderer INSTANCE = new QuadWindingDebugRenderer();
    private static final RandomSource RANDOM = RandomSource.create();
    private static final FramedBlockData FRAMED_BLOCK_DATA = new FramedBlockData(new BlockCamoContent(Blocks.STONE.defaultBlockState()), new boolean[6], false, false);

    @Override
    public void render(FramedBlockEntity be, BlockHitResult blockHit, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(be.getBlockState());
        Vector3f pos = new Vector3f();
        Vector3f norm = new Vector3f();
        Vec3 viewVector = Objects.requireNonNull(Minecraft.getInstance().player).getViewVector(partialTick).normalize();
        ModelData modelData = Objects.requireNonNull(be.getLevel()).getModelData(be.getBlockPos()).derive().with(FramedBlockData.PROPERTY, (Object)FRAMED_BLOCK_DATA).build();
        Utils.forAllDirections(side -> {
            for (BakedQuad quad : model.getQuads(be.getBlockState(), side, RANDOM, modelData, RenderType.solid())) {
                QuadData data = new QuadData(quad);
                norm.set(data.normal(0, 0), data.normal(0, 1), data.normal(0, 2)).normalize();
                float dot = norm.dot((float)viewVector.x, (float)viewVector.y, (float)viewVector.z);
                if (dot > -0.75f) continue;
                for (int i = 0; i < 4; ++i) {
                    data.pos(i, pos);
                    poseStack.pushPose();
                    poseStack.translate(pos.x, pos.y, pos.z);
                    poseStack.mulPose(Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
                    poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    poseStack.scale(0.0625f, 0.0625f, 0.0625f);
                    Minecraft.getInstance().font.drawInBatch(Integer.toString(i), -2.5f, -3.5f, -1, false, poseStack.last().pose(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    poseStack.popPose();
                }
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return DevToolsConfig.VIEW.isQuadWindingDebugRendererEnabled();
    }
}

