/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.FramingSawWithEncoderScreen;
import xfacthd.framedblocks.client.screen.IFramingSawScreen;
import xfacthd.framedblocks.client.screen.widget.SearchEditBox;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.ae2.AppliedEnergisticsCompat;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.menu.FramingSawMenu;
import xfacthd.framedblocks.common.net.payload.ServerboundSelectFramingSawRecipePayload;

public class FramingSawScreen
extends AbstractContainerScreen<FramingSawMenu>
implements IFramingSawScreen {
    public static final String TOOLTIP_MATERIAL = Utils.translationKey("tooltip", "framing_saw.material");
    public static final Component TOOLTIP_LOOSE_ADDITIVE = Utils.translate("tooltip", "framing_saw.loose_additive");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_item");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_MULTI = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_item_multi");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_TAG = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_tag");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_item_count");
    public static final String TOOLTIP_HAVE_X_BUT_NEED_Y_MATERIAL_COUNT = Utils.translationKey("tooltip", "framing_saw.have_x_but_need_y_material_count");
    public static final String TOOLTIP_OUTPUT_COUNT = Utils.translationKey("tooltip", "framing_saw.output_count");
    public static final Component TOOLTIP_HAVE_ITEM_NONE = Utils.translate("tooltip", "framing_saw.have_item_none").withStyle(ChatFormatting.GOLD);
    public static final String TOOLTIP_PRESS_TO_SHOW = Utils.translationKey("tooltip", "framing_saw.press_to_show");
    public static final Component MSG_HINT_SEARCH = Utils.translate("msg", "framing_saw.search");
    private static final ResourceLocation BACKGROUND = Utils.rl("textures/gui/framing_saw.png");
    public static final ResourceLocation WARNING_ICON = Utils.rl("neoforge", "textures/gui/experimental_warning.png");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 233;
    private static final int RECIPES_X = 48;
    private static final int RECIPES_Y = 22;
    private static final int RECIPE_ROWS = 6;
    private static final int RECIPE_COLS = 8;
    private static final int RECIPE_COUNT = 48;
    private static final int RECIPE_WIDTH = 18;
    private static final int RECIPE_HEIGHT = 18;
    private static final int SCROLL_BAR_X = 195;
    private static final int SCROLL_BAR_Y = 22;
    private static final int SCROLL_BTN_WIDTH = 12;
    private static final int SCROLL_BTN_HEIGHT = 15;
    private static final int SCROLL_BTN_TEX_X = 54;
    private static final int SCROLL_BAR_HEIGHT = 108;
    private static final int WARNING_X = 20;
    private static final int WARNING_Y = 46;
    private static final int SEARCH_WIDTH = 120;
    private static final int SEARCH_HEIGHT = 14;
    private static final int SEARCH_X = 130;
    private static final int SEARCH_Y = 5;
    protected final FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
    protected final ItemStack cubeStack = new ItemStack((ItemLike)FBContent.BLOCK_FRAMED_CUBE.value());
    private final List<FramingSawMenu.FramedRecipeHolder> filteredRecipes = new ArrayList<FramingSawMenu.FramedRecipeHolder>();
    private SearchEditBox searchBox = null;
    private int firstIndex = 0;
    private boolean scrolling = false;
    private float scrollOffset = 0.0f;
    private boolean hasEffectiveSearchQuery = false;

    protected FramingSawScreen(FramingSawMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        --this.titleLabelY;
        this.inventoryLabelX = 47;
        this.inventoryLabelY = 139;
        this.imageWidth = 256;
        this.imageHeight = 233;
        this.filteredRecipes.addAll(menu.getRecipes());
    }

    protected void init() {
        super.init();
        int searchX = this.leftPos + 130;
        int searchY = this.topPos + 5;
        this.searchBox = (SearchEditBox)this.addRenderableWidget((GuiEventListener)new SearchEditBox(this.font, searchX, searchY, 120, 14, MSG_HINT_SEARCH, this::onSearchChanged, this.searchBox));
        this.searchBox.setMaxLength(50);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(this.getBackground(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int offset = (int)(93.0f * this.scrollOffset);
        int scrollU = 54 + (this.isScrollBarActive() ? 0 : 12);
        graphics.blit(BACKGROUND, this.leftPos + 195, this.topPos + 22 + offset, scrollU, this.imageHeight, 12, 15);
        ItemStack input = this.getInputStack();
        if (!input.isEmpty() && this.cache.containsAdditive(input.getItem())) {
            graphics.blit(WARNING_ICON, this.leftPos + 20, this.topPos + 46, 8.0f, 8.0f, 24, 24, 32, 32);
        }
        int idx = ((FramingSawMenu)this.menu).getSelectedRecipeIndex();
        if (((FramingSawMenu)this.menu).hasRecipeChanged()) {
            this.handleRecipeChange();
        }
        int recX = this.leftPos + 48;
        int recY = this.topPos + 22;
        int lastIndex = this.firstIndex + 48;
        this.renderButtons(graphics, mouseX, mouseY, recX, recY, lastIndex);
        this.renderRecipes(graphics, recX, recY, lastIndex);
        List<RecipeHolder<FramingSawRecipe>> recipes = this.cache.getRecipes();
        if (idx >= 0 && idx < recipes.size()) {
            FramingSawRecipe recipe = (FramingSawRecipe)recipes.get(idx).value();
            this.drawInputStackHint(graphics, input);
            List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
            for (int i = 0; i < additives.size(); ++i) {
                ItemStack additive = this.getAdditiveStack(i);
                int y = this.topPos + 64 + 18 * i;
                this.drawAdditiveStackHint(graphics, i, additive, additives, y);
            }
        }
    }

    protected ResourceLocation getBackground() {
        return BACKGROUND;
    }

    @Override
    public ItemStack getInputStack() {
        return ((FramingSawMenu)this.menu).getInputStack();
    }

    @Override
    public ItemStack getAdditiveStack(int slot) {
        return ((FramingSawMenu)this.menu).getAdditiveStack(slot);
    }

    @Override
    public RecipeInput getRecipeInput() {
        return ((FramingSawMenu)this.menu).getRecipeInput();
    }

    protected void handleRecipeChange() {
        this.tryScrollToRecipe(((FramingSawMenu)this.menu).getSelectedRecipeIndex());
    }

    protected boolean drawInputStackHint(GuiGraphics graphics, ItemStack input) {
        if (input.isEmpty()) {
            ClientUtils.renderTransparentFakeItem(graphics, this.cubeStack, this.leftPos + 20, this.topPos + 28);
            return true;
        }
        return false;
    }

    protected boolean drawAdditiveStackHint(GuiGraphics graphics, int index, ItemStack additive, List<FramingSawRecipeAdditive> additives, int y) {
        if (additive.isEmpty()) {
            ItemStack[] items = additives.get(index).ingredient().getItems();
            int t = (int)(System.currentTimeMillis() / 1700L) % items.length;
            ClientUtils.renderTransparentFakeItem(graphics, items[t], this.leftPos + 20, y);
            return true;
        }
        return false;
    }

    protected boolean displayRecipeErrors() {
        return true;
    }

    private void tryScrollToRecipe(int idx) {
        if (idx != -1 && this.hasEffectiveSearchQuery) {
            FramingSawMenu.FramedRecipeHolder recipe = ((FramingSawMenu)this.menu).getRecipes().get(idx);
            idx = this.filteredRecipes.indexOf(recipe);
        }
        if (idx != -1 && (idx < this.firstIndex || idx >= this.firstIndex + 48)) {
            int row = idx / 8 - 2;
            int hidden = this.getHiddenRows();
            this.scrollOffset = (float)row / (float)hidden;
            this.scrollOffset = Mth.clamp((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(hidden);
        } else if (idx == -1) {
            this.firstIndex = 0;
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((FramingSawMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            this.renderItemTooltip(graphics, mouseX, mouseY, this.hoveredSlot.getItem(), null);
            return;
        }
        ItemStack input = this.getInputStack();
        if (!input.isEmpty() && this.isHovering(20, 46, 16, 16, mouseX, mouseY) && this.cache.containsAdditive(input.getItem())) {
            graphics.renderTooltip(this.font, TOOLTIP_LOOSE_ADDITIVE, mouseX, mouseY);
            return;
        }
        int x = this.leftPos + 48;
        int y = this.topPos + 22;
        int last = this.firstIndex + 48;
        for (int idx = this.firstIndex; idx < last && idx < this.filteredRecipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int recX = x + relIdx % 8 * 18;
            int recY = y + relIdx / 8 * 18;
            if (mouseX < recX || mouseX >= recX + 18 || mouseY < recY || mouseY >= recY + 18) continue;
            FramingSawMenu.FramedRecipeHolder recipe = this.filteredRecipes.get(idx);
            ItemStack result = recipe.getRecipe().getResult();
            this.renderItemTooltip(graphics, mouseX, mouseY, result, recipe);
            break;
        }
    }

    protected void renderItemTooltip(GuiGraphics graphics, int mouseX, int mouseY, ItemStack stack, FramingSawMenu.FramedRecipeHolder recipeHolder) {
        ArrayList<Component> components = new ArrayList<Component>(FramingSawScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)stack));
        Optional tooltip = stack.getTooltipImage();
        int material = this.cache.getMaterialValue(stack.getItem());
        if (material > 0) {
            components.add((Component)Component.translatable((String)TOOLTIP_MATERIAL, (Object[])new Object[]{material}));
        }
        if (recipeHolder != null && this.displayRecipeErrors()) {
            this.appendRecipeFailure(components, recipeHolder);
        }
        graphics.renderTooltip(this.font, components, tooltip, stack, mouseX, mouseY);
    }

    private void appendRecipeFailure(List<Component> components, FramingSawMenu.FramedRecipeHolder recipeHolder) {
        FramingSawScreen.appendRecipeFailure(components, this.cache, recipeHolder.getRecipe(), recipeHolder.getMatchResult(), this);
    }

    public static List<Component> appendRecipeFailure(List<Component> components, FramingSawRecipeCache cache, FramingSawRecipe recipe, FramingSawRecipeMatchResult matchResult, IFramingSawScreen screen) {
        if (!matchResult.success()) {
            components.add(matchResult.translation());
            ItemStack input = screen.getInputStack();
            int listAdditives = -1;
            MutableComponent detail = switch (matchResult) {
                default -> throw new MatchException(null, null);
                case FramingSawRecipeMatchResult.MATERIAL_VALUE -> {
                    int matIn = input.isEmpty() ? 0 : cache.getMaterialValue(input.getItem()) * input.getCount();
                    int matReq = recipe.getMaterialAmount();
                    yield Component.translatable((String)TOOLTIP_HAVE_X_BUT_NEED_Y_MATERIAL_COUNT, (Object[])new Object[]{Component.literal((String)Integer.toString(matIn)).withStyle(ChatFormatting.GOLD), Component.literal((String)Integer.toString(matReq)).withStyle(ChatFormatting.GOLD)});
                }
                case FramingSawRecipeMatchResult.MATERIAL_LCM -> {
                    if (input.isEmpty()) {
                        yield Component.empty();
                    }
                    FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(screen.getRecipeInput(), true);
                    yield Component.translatable((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT, (Object[])new Object[]{Component.literal((String)Integer.toString(input.getCount())).withStyle(ChatFormatting.GOLD), Component.literal((String)Integer.toString(calc.getInputCount())).withStyle(ChatFormatting.GOLD)});
                }
                case FramingSawRecipeMatchResult.OUTPUT_SIZE -> {
                    if (input.isEmpty()) {
                        yield Component.empty();
                    }
                    FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(screen.getRecipeInput(), true);
                    int maxSize = recipe.getResult().getMaxStackSize();
                    yield Component.translatable((String)TOOLTIP_OUTPUT_COUNT, (Object[])new Object[]{calc.getOutputCount(), maxSize});
                }
                case FramingSawRecipeMatchResult.MISSING_ADDITIVE_0, FramingSawRecipeMatchResult.MISSING_ADDITIVE_1, FramingSawRecipeMatchResult.MISSING_ADDITIVE_2 -> {
                    listAdditives = matchResult.additiveSlot();
                    FramingSawRecipeAdditive additive = recipe.getAdditives().get(matchResult.additiveSlot());
                    yield FramingSawScreen.makeHaveButNeedTooltip(TOOLTIP_HAVE_ITEM_NONE, additive);
                }
                case FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_0, FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_1, FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_2 -> {
                    Item itemIn = screen.getAdditiveStack(matchResult.additiveSlot()).getItem();
                    yield Component.translatable((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM, (Object[])new Object[]{Component.translatable((String)itemIn.getDescriptionId()).withStyle(ChatFormatting.GOLD), TOOLTIP_HAVE_ITEM_NONE});
                }
                case FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_0, FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_1, FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_2 -> {
                    listAdditives = matchResult.additiveSlot();
                    Item itemIn = screen.getAdditiveStack(matchResult.additiveSlot()).getItem();
                    yield FramingSawScreen.makeHaveButNeedTooltip((Component)Component.translatable((String)itemIn.getDescriptionId()).withStyle(ChatFormatting.GOLD), recipe.getAdditives().get(matchResult.additiveSlot()));
                }
                case FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_0, FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_1, FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_2 -> {
                    if (input.isEmpty()) {
                        yield Component.empty();
                    }
                    FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(screen.getRecipeInput(), true);
                    int cntIn = screen.getAdditiveStack(matchResult.additiveSlot()).getCount();
                    int cntReq = calc.getAdditiveCount(matchResult.additiveSlot());
                    yield Component.translatable((String)TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT, (Object[])new Object[]{Component.literal((String)Integer.toString(cntIn)).withStyle(ChatFormatting.GOLD), Component.literal((String)Integer.toString(cntReq)).withStyle(ChatFormatting.GOLD)});
                }
                case FramingSawRecipeMatchResult.SUCCESS -> throw new IllegalStateException("Unreachable");
            };
            components.add((Component)detail.withStyle(ChatFormatting.RED));
            if (listAdditives > -1) {
                FramingSawScreen.appendAdditiveItemOptions(components, recipe, listAdditives);
            }
        }
        return components;
    }

    private static void appendAdditiveItemOptions(List<Component> components, FramingSawRecipe recipe, int additiveSlot) {
        FramingSawRecipeAdditive additive = recipe.getAdditives().get(additiveSlot);
        if (!additive.isTagBased() && additive.ingredient().getItems().length <= 1) {
            return;
        }
        if (FramingSawScreen.hasShiftDown()) {
            for (ItemStack option : additive.ingredient().getItems()) {
                components.add((Component)Component.literal((String)"- ").append(option.getItem().getDescription()).withStyle(ChatFormatting.GOLD));
            }
        } else {
            Component keyName = InputConstants.getKey((int)340, (int)-1).getDisplayName();
            components.add((Component)Component.translatable((String)TOOLTIP_PRESS_TO_SHOW, (Object[])new Object[]{Component.literal((String)"").append(keyName).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.RED));
        }
    }

    private static MutableComponent makeHaveButNeedTooltip(Component present, FramingSawRecipeAdditive additive) {
        if (additive.isTagBased()) {
            return Component.translatable((String)TOOLTIP_HAVE_X_BUT_NEED_Y_TAG, (Object[])new Object[]{present, Utils.translateTag(additive.srcTag()).withStyle(ChatFormatting.GOLD)});
        }
        ItemStack[] options = additive.ingredient().getItems();
        return Component.translatable((String)(options.length > 1 ? TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_MULTI : TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM), (Object[])new Object[]{present, Component.translatable((String)options[0].getItem().getDescriptionId()).withStyle(ChatFormatting.GOLD)});
    }

    private void renderButtons(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int lastIdx) {
        int selIdx = ((FramingSawMenu)this.menu).getSelectedRecipeIndex();
        if (selIdx != -1 && this.hasEffectiveSearchQuery) {
            FramingSawMenu.FramedRecipeHolder recipe = ((FramingSawMenu)this.menu).getRecipes().get(selIdx);
            selIdx = this.filteredRecipes.indexOf(recipe);
        }
        for (int idx = this.firstIndex; idx < lastIdx && idx < this.filteredRecipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int recX = x + relIdx % 8 * 18;
            int recY = y + relIdx / 8 * 18;
            int u = 0;
            boolean hovered = false;
            if (idx == selIdx) {
                u += 18;
            } else if (mouseX >= recX && mouseY >= recY && mouseX < recX + 18 && mouseY < recY + 18) {
                u += 36;
                hovered = true;
            }
            if (!hovered && this.displayRecipeErrors() && !this.filteredRecipes.get(idx).getMatchResult().success()) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            graphics.blit(BACKGROUND, recX, recY, u, this.imageHeight, 18, 18);
        }
    }

    private void renderRecipes(GuiGraphics graphics, int pLeft, int pTop, int lastIndex) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int idx = this.firstIndex; idx < lastIndex && idx < this.filteredRecipes.size(); ++idx) {
            int relIdx = idx - this.firstIndex;
            int x = pLeft + relIdx % 8 * 18 + 1;
            int y = pTop + relIdx / 8 * 18 + 1;
            ItemStack stack = this.filteredRecipes.get(idx).getRecipe().getResult();
            graphics.renderItem(stack, x, y, x * y * this.imageWidth);
            graphics.renderItemDecorations(this.font, stack, x, y);
        }
    }

    protected void containerTick() {
        this.searchBox.tick();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        GuiEventListener focused = this.getFocused();
        if (focused != null && !focused.isMouseOver(mouseX, mouseY)) {
            this.setFocused(null);
        }
        int x = this.leftPos + 48;
        int y = this.topPos + 22;
        int lastIdx = this.firstIndex + 48;
        for (int idx = this.firstIndex; idx < lastIdx; ++idx) {
            int relIdx = idx - this.firstIndex;
            double recRelX = mouseX - (double)(x + relIdx % 8 * 18);
            double recRelY = mouseY - (double)(y + relIdx / 8 * 18);
            if (recRelX < 0.0 || recRelY < 0.0 || recRelX > 18.0 || recRelY > 18.0) continue;
            if (this.hasEffectiveSearchQuery) {
                if (idx < 0 || idx >= this.filteredRecipes.size()) break;
                RecipeHolder<FramingSawRecipe> recipe = this.filteredRecipes.get(idx).toVanilla();
                idx = this.cache.getRecipes().indexOf(recipe);
                if (idx == -1) break;
            }
            if (!((FramingSawMenu)this.menu).clickMenuButton((Player)this.minecraft.player, idx)) continue;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSelectFramingSawRecipePayload(((FramingSawMenu)this.menu).containerId, idx), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (this.isScrollBarActive()) {
            x = this.leftPos + 195;
            y = this.topPos + 22;
            if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 108)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            float topY = this.topPos + 22;
            float botY = topY + 108.0f;
            float freeScrollHeight = botY - topY - 15.0f;
            this.scrollOffset = ((float)mouseY - topY - 7.5f) / freeScrollHeight;
            this.scrollOffset = Mth.clamp((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(this.getHiddenRows());
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isScrollBarActive()) {
            int hiddenRows = this.getHiddenRows();
            float offset = (float)deltaY / (float)hiddenRows;
            this.scrollOffset = Mth.clamp((float)(this.scrollOffset - offset), (float)0.0f, (float)1.0f);
            this.firstIndex = this.calculateFirstIndex(hiddenRows);
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.isFocused() && Objects.requireNonNull(this.minecraft).options.keyInventory.matches(keyCode, scanCode)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public PointedRecipe getRecipeAt(double mouseX, double mouseY) {
        int col;
        int row;
        int idx;
        double x = this.leftPos + 48;
        double y = this.topPos + 22;
        if (mouseX >= x && mouseX <= x + 144.0 && mouseY >= y && mouseY <= y + 108.0 && (idx = (row = (int)((mouseY - y) / 18.0)) * 8 + (col = (int)((mouseX - x) / 18.0)) + this.firstIndex) > 0 && idx < this.filteredRecipes.size()) {
            int rx = (int)x + col * 18;
            int ry = (int)y + row * 18;
            return new PointedRecipe(this.filteredRecipes.get(idx).toVanilla(), rx, ry);
        }
        return null;
    }

    private void onSearchChanged(String query) {
        if (query.isBlank()) {
            this.filteredRecipes.clear();
            this.filteredRecipes.addAll(((FramingSawMenu)this.menu).getRecipes());
            this.hasEffectiveSearchQuery = false;
            this.tryScrollToRecipe(((FramingSawMenu)this.menu).getSelectedRecipeIndex());
            return;
        }
        this.filteredRecipes.clear();
        query = query.toLowerCase(Locale.ROOT);
        for (FramingSawMenu.FramedRecipeHolder recipe : ((FramingSawMenu)this.menu).getRecipes()) {
            Component name = recipe.getRecipe().getResult().getItem().getDescription();
            if (!name.getString().toLowerCase(Locale.ROOT).contains(query)) continue;
            this.filteredRecipes.add(recipe);
        }
        boolean bl = this.hasEffectiveSearchQuery = this.filteredRecipes.size() != ((FramingSawMenu)this.menu).getRecipes().size();
        if (this.filteredRecipes.contains(((FramingSawMenu)this.menu).getRecipes().get(((FramingSawMenu)this.menu).getSelectedRecipeIndex()))) {
            this.tryScrollToRecipe(((FramingSawMenu)this.menu).getSelectedRecipeIndex());
        }
    }

    private boolean isScrollBarActive() {
        return this.filteredRecipes.size() > 48;
    }

    private int getHiddenRows() {
        return (this.filteredRecipes.size() + 8 - 1) / 8 - 6;
    }

    private int calculateFirstIndex(int hiddenRows) {
        int idx = (int)((double)(this.scrollOffset * (float)hiddenRows) + 0.5) * 8;
        return Mth.clamp((int)idx, (int)0, (int)(this.filteredRecipes.size() - 1));
    }

    public static FramingSawScreen create(FramingSawMenu menu, Inventory inv, Component title) {
        if (AppliedEnergisticsCompat.isLoaded()) {
            return new FramingSawWithEncoderScreen(menu, inv, title);
        }
        return new FramingSawScreen(menu, inv, title);
    }

    public record PointedRecipe(ResourceLocation id, FramingSawRecipe recipe, Rect2i area) {
        private PointedRecipe(RecipeHolder<FramingSawRecipe> recipe, int x, int y) {
            this(recipe.id(), (FramingSawRecipe)recipe.value(), new Rect2i(x, y, 18, 18));
        }
    }
}

