/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.block.render.ParticleHelper;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockStateCache;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;

public interface IFramedDoubleBlock
extends IFramedBlock {
    @Override
    default public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            return be.getSoundType();
        }
        return state.getSoundType();
    }

    @Override
    default public boolean isCamoEmissiveRendering(BlockState state, BlockGetter level, BlockPos pos) {
        ModelData modelData = level.getModelData(pos);
        if (modelData == ModelData.EMPTY) {
            return false;
        }
        return IFramedBlock.isCamoEmissiveRendering((ModelData)modelData.get(FramedDoubleBlockEntity.DATA_LEFT)) || IFramedBlock.isCamoEmissiveRendering((ModelData)modelData.get(FramedDoubleBlockEntity.DATA_RIGHT));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    @ApiStatus.OverrideOnly
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState var1);

    @ApiStatus.OverrideOnly
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState var1);

    @ApiStatus.OverrideOnly
    public SolidityCheck calculateSolidityCheck(BlockState var1, Direction var2);

    @ApiStatus.OverrideOnly
    public CamoGetter calculateCamoGetter(BlockState var1, Direction var2, @Nullable Direction var3);

    @ApiStatus.NonExtendable
    default public DoubleBlockTopInteractionMode getTopInteractionMode(BlockState state) {
        return this.getCache(state).getTopInteractionMode();
    }

    @ApiStatus.NonExtendable
    default public Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        return this.getCache(state).getBlockPair();
    }

    @ApiStatus.NonExtendable
    default public SolidityCheck getSolidityCheck(BlockState state, Direction side) {
        return this.getCache(state).getSolidityCheck(side);
    }

    @ApiStatus.NonExtendable
    default public CamoGetter getCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        return this.getCache(state).getCamoGetter(side, edge);
    }

    @Override
    default public StateCache initCache(BlockState state) {
        return new DoubleBlockStateCache(state, this.getBlockType());
    }

    @Override
    default public DoubleBlockStateCache getCache(BlockState state) {
        return (DoubleBlockStateCache)IFramedBlock.super.getCache(state);
    }

    @Override
    @Nullable
    default public BlockState runOcclusionTestAndGetLookupState(SideSkipPredicate pred, BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> statePair = this.getBlockPair(adjState);
        if (pred.test(level, pos, state, (BlockState)statePair.getA(), side)) {
            return (BlockState)statePair.getA();
        }
        if (pred.test(level, pos, state, (BlockState)statePair.getB(), side)) {
            return (BlockState)statePair.getB();
        }
        return null;
    }

    @Override
    @Nullable
    default public BlockState getComponentAtEdge(BlockGetter level, BlockPos pos, BlockState state, Direction side, @Nullable Direction edge) {
        DoubleBlockStateCache cache = this.getCache(state);
        return cache.getCamoGetter(side, edge).getComponent(cache.getBlockPair());
    }

    @Override
    @Nullable
    default public BlockState getComponentBySkipPredicate(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction side) {
        Tuple<BlockState, BlockState> blockPair = this.getBlockPair(state);
        BlockState compA = (BlockState)blockPair.getA();
        if (IFramedDoubleBlock.testComponent(level, pos, compA, neighborState, side)) {
            return compA;
        }
        BlockState compB = (BlockState)blockPair.getB();
        if (IFramedDoubleBlock.testComponent(level, pos, compB, neighborState, side)) {
            return compB;
        }
        return null;
    }

    public static boolean testComponent(BlockGetter ctLevel, BlockPos pos, BlockState component, BlockState neighborState, Direction side) {
        IFramedBlock block = (IFramedBlock)component.getBlock();
        return block.getBlockType().getSideSkipPredicate().test(ctLevel, pos, component, neighborState, side);
    }

    @Override
    default public ModelData unpackNestedModelData(ModelData data, BlockState state, BlockState componentState) {
        Tuple<BlockState, BlockState> blockPair = this.getBlockPair(state);
        if (componentState == blockPair.getA()) {
            return Objects.requireNonNullElse((ModelData)data.get(FramedDoubleBlockEntity.DATA_LEFT), ModelData.EMPTY);
        }
        if (componentState == blockPair.getB()) {
            return Objects.requireNonNullElse((ModelData)data.get(FramedDoubleBlockEntity.DATA_RIGHT), ModelData.EMPTY);
        }
        return ModelData.EMPTY;
    }

    @Override
    default public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            Tuple<BlockState, BlockState> statePair = this.getBlockPair(state);
            switch (this.getTopInteractionMode(state)) {
                case FIRST: {
                    ParticleHelper.spawnRunningParticles(be.getCamo((BlockState)statePair.getA()), level, pos, entity);
                    break;
                }
                case SECOND: {
                    ParticleHelper.spawnRunningParticles(be.getCamo((BlockState)statePair.getB()), level, pos, entity);
                    break;
                }
                case EITHER: {
                    ParticleHelper.spawnRunningParticles(be.getCamo((BlockState)statePair.getA()), level, pos, entity);
                    ParticleHelper.spawnRunningParticles(be.getCamo((BlockState)statePair.getB()), level, pos, entity);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean addLandingEffects(BlockState state, ServerLevel level, BlockPos pos, BlockState sameState, LivingEntity entity, int count) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            Tuple<BlockState, BlockState> statePair = this.getBlockPair(state);
            switch (this.getTopInteractionMode(state)) {
                case FIRST: {
                    ParticleHelper.spawnLandingParticles(be.getCamo((BlockState)statePair.getA()), level, pos, entity, count);
                    break;
                }
                case SECOND: {
                    ParticleHelper.spawnLandingParticles(be.getCamo((BlockState)statePair.getB()), level, pos, entity, count);
                    break;
                }
                case EITHER: {
                    ParticleHelper.spawnLandingParticles(be.getCamo((BlockState)statePair.getA()), level, pos, entity, count);
                    ParticleHelper.spawnLandingParticles(be.getCamo((BlockState)statePair.getB()), level, pos, entity, count);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    default public Optional<MutableComponent> printCamoData(CamoList camos, boolean blueprint) {
        return IFramedDoubleBlock.printCamoData(camos.getCamo(0), camos.getCamo(1), blueprint);
    }

    public static Optional<MutableComponent> printCamoData(CamoContainer<?, ?> camoContainer, CamoContainer<?, ?> camoContainerTwo, boolean force) {
        if (force || !camoContainer.isEmpty() || !camoContainerTwo.isEmpty()) {
            MutableComponent component = IFramedDoubleBlock.getCamoComponent(camoContainer);
            component.append((Component)Component.literal((String)" | ").withStyle(ChatFormatting.GOLD));
            component.append((Component)IFramedDoubleBlock.getCamoComponent(camoContainerTwo));
            return Optional.of(component);
        }
        return Optional.empty();
    }

    public static MutableComponent getCamoComponent(CamoContainer<?, ?> camoContainer) {
        if (!camoContainer.isEmpty()) {
            return ((CamoContent)camoContainer.getContent()).getCamoName().withStyle(ChatFormatting.WHITE);
        }
        return FramedBlueprintItem.BLOCK_NONE.copy();
    }
}

