/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.door;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.blueprint.BlueprintData;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.model.wrapping.WrapHelper;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedDoorBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.blueprint.DoorCopyBehaviour;

public class FramedDoorBlock
extends DoorBlock
implements IFramedBlock {
    private final BlockType type;

    private FramedDoorBlock(BlockType type, BlockSetType blockSet, BlockBehaviour.Properties props) {
        super(blockSet, props);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.SOLID, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = this.handleUse(state, level, pos, player, hand, hit);
        return result.consumesAction() ? result : super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos.above());
        if (blockEntity instanceof FramedDoorBlockEntity) {
            FramedDoorBlockEntity be = (FramedDoorBlockEntity)blockEntity;
            be.applyComponentsFromItemStack(stack);
        }
        this.tryApplyCamoImmediately(level, pos, placer, stack);
        this.tryApplyCamoImmediately(level, pos.above(), placer, stack);
    }

    protected BlockState updateShape(BlockState state, Direction side, BlockState adjState, LevelAccessor level, BlockPos pos, BlockPos adjPos) {
        BlockState newState = super.updateShape(state, side, adjState, level, pos, adjPos);
        if (newState.getBlock() == this) {
            newState = (BlockState)newState.setValue((Property)FramedProperties.SOLID, (Comparable)((Boolean)state.getValue((Property)FramedProperties.SOLID)));
            newState = Utils.copyRequiredProperties(state, newState);
        }
        if (newState == state) {
            this.updateCulling((LevelReader)level, pos);
        }
        return newState;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        this.updateCulling((LevelReader)level, pos);
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos, null);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> lines, TooltipFlag flag) {
        this.appendCamoHoverText(stack, lines);
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoorBlockEntity(pos, state);
    }

    @Override
    public Optional<MutableComponent> printCamoBlock(BlueprintData blueprintData) {
        CamoContainer<?, ?> camoContainer = blueprintData.camos().getCamo(0);
        CamoContainer<?, ?> camoContainerTwo = DoorCopyBehaviour.getSecondData(blueprintData).camos().getCamo(0);
        return IFramedDoubleBlock.printCamoData(camoContainer, camoContainerTwo, true);
    }

    @Override
    public Optional<MutableComponent> printCamoData(CamoList camos, boolean blueprint) {
        return IFramedDoubleBlock.printCamoData(camos.getCamo(0), camos.getCamo(1), blueprint);
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public boolean shouldRenderAsBlockInJadeTooltip() {
        return false;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return state;
    }

    public static FramedDoorBlock wood() {
        return new FramedDoorBlock(BlockType.FRAMED_DOOR, BlockSetType.OAK, IFramedBlock.createProperties(BlockType.FRAMED_DOOR));
    }

    public static FramedDoorBlock iron() {
        return new FramedDoorBlock(BlockType.FRAMED_IRON_DOOR, BlockSetType.IRON, IFramedBlock.createProperties(BlockType.FRAMED_IRON_DOOR).requiresCorrectToolForDrops());
    }

    public static final class DoorStateMerger
    implements StateMerger {
        public static final DoorStateMerger INSTANCE = new DoorStateMerger();
        private final StateMerger ignoreMerger = StateMerger.ignoring(Utils.concat(Set.of(BlockStateProperties.POWERED), WrapHelper.IGNORE_SOLID));

        private DoorStateMerger() {
        }

        @Override
        public BlockState apply(BlockState state) {
            if (((Boolean)(state = this.ignoreMerger.apply(state)).getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
                Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)BlockStateProperties.DOOR_HINGE);
                boolean right = hinge == DoorHingeSide.RIGHT;
                Direction newDir = right ? dir.getCounterClockWise() : dir.getClockWise();
                DoorHingeSide newHinge = right ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
                state = (BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)newDir)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)newHinge);
            }
            return state;
        }

        @Override
        public Set<Property<?>> getHandledProperties(Holder<Block> block) {
            return Utils.concat(this.ignoreMerger.getHandledProperties(block), Set.of(BlockStateProperties.OPEN, BlockStateProperties.DOOR_HINGE));
        }
    }
}

