/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedItemFrameBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedItemFrameBlock
extends FramedBlock {
    private static final SoundType NORMAL_SOUND = new SoundType(1.0f, 1.0f, SoundEvents.ITEM_FRAME_BREAK, SoundEvents.EMPTY, SoundEvents.ITEM_FRAME_PLACE, SoundEvents.SCAFFOLDING_HIT, SoundEvents.EMPTY);
    private static final SoundType GLOWING_SOUND = new SoundType(1.0f, 1.0f, SoundEvents.GLOW_ITEM_FRAME_BREAK, SoundEvents.EMPTY, SoundEvents.GLOW_ITEM_FRAME_PLACE, SoundEvents.SCAFFOLDING_HIT, SoundEvents.EMPTY);

    public FramedItemFrameBlock(BlockType type) {
        super(type, IFramedBlock.createProperties(type).instabreak().noCollission().isSuffocating((s, l, p) -> false).isViewBlocking((s, l, p) -> false).sound(type == BlockType.FRAMED_ITEM_FRAME ? NORMAL_SOUND : GLOWING_SOUND));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.LEATHER, (Comparable)Boolean.valueOf(false))).setValue((Property)PropertyHolder.MAP_FRAME, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING, PropertyHolder.LEATHER, PropertyHolder.MAP_FRAME});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTargetFacing()).validate((state, modCtx) -> this.canSurvive((BlockState)state, (LevelReader)modCtx.getLevel(), modCtx.getClickedPos()))).build();
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.relative(dir));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hit);
        if (result.consumesAction()) {
            return result;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedItemFrameBlockEntity) {
            FramedItemFrameBlockEntity be = (FramedItemFrameBlockEntity)blockEntity;
            return be.handleFrameInteraction(player, hand);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        FramedItemFrameBlockEntity be;
        if (player.getMainHandItem().is((Item)FBContent.ITEM_FRAMED_HAMMER.value())) {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)PropertyHolder.LEATHER));
            }
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedItemFrameBlockEntity && (be = (FramedItemFrameBlockEntity)blockEntity).hasItem()) {
            if (!level.isClientSide()) {
                be.removeItem(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getSoundType(state);
    }

    @Override
    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    @Override
    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return true;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        FramedItemFrameBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedItemFrameBlockEntity && (be = (FramedItemFrameBlockEntity)blockEntity).hasItem()) {
            return be.getCloneItem();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate(dir));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.FACING, mirror);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedItemFrameBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide() && ((Boolean)state.getValue((Property)PropertyHolder.MAP_FRAME)).booleanValue()) {
            return Utils.createBlockEntityTicker(type, (BlockEntityType)FBContent.BE_TYPE_FRAMED_ITEM_FRAME.value(), (l, p, s, be) -> be.tickWithMap());
        }
        return null;
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH);
    }

    @Override
    public float getJadeRenderScale(BlockState state) {
        return 1.3f;
    }
}

