/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedLeverBlock
extends LeverBlock
implements IFramedBlock {
    public FramedLeverBlock() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f).noOcclusion().sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = this.handleUse(state, level, pos, player, hand, hit);
        return result.consumesAction() ? result : super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (state.getValue((Property)FACE) != AttachFace.WALL) {
            return this.rotate(state, rot);
        }
        return state;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> lines, TooltipFlag flag) {
        this.appendCamoHoverText(stack, lines);
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.FRAMED_LEVER;
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)AttachFace.FLOOR);
    }

    @Override
    public float getJadeRenderScale(BlockState state) {
        return 1.6f;
    }

    @Override
    public boolean shouldApplyGuiTransformFromModel() {
        return false;
    }
}

