/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive.pressureplate;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.wrapping.WrapHelper;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.interactive.pressureplate.FramedWaterloggableWeightedPressurePlateBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWeightedPressurePlateBlock
extends WeightedPressurePlateBlock
implements IFramedBlock {
    public static final WeightedStateMerger STATE_MERGER = new WeightedStateMerger();
    private static final Map<BlockType, BlockType> WATERLOGGING_SWITCH = Map.of(BlockType.FRAMED_GOLD_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE, BlockType.FRAMED_GOLD_PRESSURE_PLATE, BlockType.FRAMED_IRON_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE, BlockType.FRAMED_IRON_PRESSURE_PLATE);
    private final BlockType type;

    protected FramedWeightedPressurePlateBlock(BlockType type, int maxWeight, BlockSetType blockSet, BlockBehaviour.Properties props) {
        super(maxWeight, blockSet, props);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.getMainHandItem().is((Item)FBContent.ITEM_FRAMED_HAMMER.value())) {
            if (!level.isClientSide()) {
                Utils.wrapInStateCopy((LevelAccessor)level, pos, player, ItemStack.EMPTY, false, false, () -> {
                    BlockState newState = this.getCounterpart().defaultBlockState();
                    level.setBlockAndUpdate(pos, newState);
                });
            }
            return true;
        }
        return false;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> lines, TooltipFlag flag) {
        this.appendCamoHoverText(stack, lines);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    protected final Block getCounterpart() {
        return FBContent.byType(WATERLOGGING_SWITCH.get(this.type));
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public Class<? extends Block> getJadeTargetClass() {
        return FramedWeightedPressurePlateBlock.class;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    public static FramedWeightedPressurePlateBlock gold() {
        return new FramedWeightedPressurePlateBlock(BlockType.FRAMED_GOLD_PRESSURE_PLATE, 15, BlockSetType.GOLD, IFramedBlock.createProperties(BlockType.FRAMED_GOLD_PRESSURE_PLATE).noCollission().strength(0.5f));
    }

    public static FramedWeightedPressurePlateBlock goldWaterloggable() {
        return new FramedWaterloggableWeightedPressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE, 15, BlockSetType.GOLD, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE).noCollission().strength(0.5f));
    }

    public static FramedWeightedPressurePlateBlock iron() {
        return new FramedWeightedPressurePlateBlock(BlockType.FRAMED_IRON_PRESSURE_PLATE, 150, BlockSetType.IRON, IFramedBlock.createProperties(BlockType.FRAMED_IRON_PRESSURE_PLATE).requiresCorrectToolForDrops().noCollission().strength(0.5f));
    }

    public static FramedWeightedPressurePlateBlock ironWaterloggable() {
        return new FramedWaterloggableWeightedPressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE, 150, BlockSetType.IRON, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE).requiresCorrectToolForDrops().noCollission().strength(0.5f));
    }

    public static final class WeightedStateMerger
    implements StateMerger {
        private final StateMerger ignoringMerger = StateMerger.ignoring(WrapHelper.IGNORE_ALWAYS);

        @Override
        public BlockState apply(BlockState state) {
            if ((state = this.ignoringMerger.apply(state)).hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            if ((Integer)state.getValue((Property)WeightedPressurePlateBlock.POWER) > 1) {
                state = (BlockState)state.setValue((Property)WeightedPressurePlateBlock.POWER, (Comparable)Integer.valueOf(1));
            }
            return state;
        }

        @Override
        public Set<Property<?>> getHandledProperties(Holder<Block> block) {
            return Utils.concat(this.ignoringMerger.getHandledProperties(block), Set.of(BlockStateProperties.WATERLOGGED, WeightedPressurePlateBlock.POWER));
        }
    }
}

