/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class FramedDoubleSlabBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleSlabBlock() {
        super(BlockType.FRAMED_DOUBLE_SLAB);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)FBContent.BLOCK_FRAMED_SLAB.value());
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_SLAB.value()).defaultBlockState();
        return new Tuple((Object)((BlockState)defState.setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)defState.setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        if (side == Direction.UP) {
            return CamoGetter.SECOND;
        }
        if (side == Direction.DOWN) {
            return CamoGetter.FIRST;
        }
        if (edge == Direction.UP) {
            return CamoGetter.SECOND;
        }
        if (edge == Direction.DOWN) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return switch (side) {
            case Direction.DOWN -> SolidityCheck.FIRST;
            case Direction.UP -> SolidityCheck.SECOND;
            default -> SolidityCheck.BOTH;
        };
    }

    @Override
    public final BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }
}

