/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedDividedSlopeBlock
extends AbstractFramedDoubleBlock
implements ISlopeBlock {
    public FramedDividedSlopeBlock() {
        super(BlockType.FRAMED_DIVIDED_SLOPE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndSlopeType().withWater()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        if (Utils.isY(face) || type != SlopeType.HORIZONTAL && face == dir.getOpposite()) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE && face == dir) {
            return (BlockState)state.cycle(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (state.getValue(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
    }

    @Override
    public SlopeType getSlopeType(BlockState state) {
        return (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (type == SlopeType.HORIZONTAL) {
            BlockState defState = ((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_SLOPE.value()).defaultBlockState();
            return new Tuple((Object)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
        }
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_HALF_SLOPE.value()).defaultBlockState();
        boolean top = type == SlopeType.TOP;
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        boolean horizontal = state.getValue(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL;
        return horizontal ? DoubleBlockTopInteractionMode.SECOND : DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        if (type == SlopeType.HORIZONTAL) {
            if (side == Direction.UP && (edge == facing || edge == facing.getCounterClockWise())) {
                return CamoGetter.SECOND;
            }
            if (side == Direction.DOWN && (edge == facing || edge == facing.getCounterClockWise())) {
                return CamoGetter.FIRST;
            }
            if (side == facing || side == facing.getCounterClockWise()) {
                if (edge == Direction.UP) {
                    return CamoGetter.SECOND;
                }
                if (edge == Direction.DOWN) {
                    return CamoGetter.FIRST;
                }
            }
        } else {
            Direction dirTwo;
            Direction direction = dirTwo = type == SlopeType.TOP ? Direction.UP : Direction.DOWN;
            if (side == facing.getClockWise() && (edge == facing || edge == dirTwo)) {
                return CamoGetter.SECOND;
            }
            if (side == facing.getCounterClockWise() && (edge == facing || edge == dirTwo)) {
                return CamoGetter.FIRST;
            }
            if (side == facing || side == dirTwo) {
                if (edge == facing.getClockWise()) {
                    return CamoGetter.SECOND;
                }
                if (edge == facing.getCounterClockWise()) {
                    return CamoGetter.FIRST;
                }
            }
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction secDir;
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case TOP: {
                Direction direction = Direction.UP;
                break;
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = secDir = facing.getCounterClockWise();
            }
        }
        if (side == facing || side == secDir) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

