/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.standard;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.wrapping.WrapHelper;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedStairsBlock
extends StairBlock
implements IFramedBlock {
    private final BlockType type;

    public FramedStairsBlock(BlockType type) {
        super(((Block)FBContent.BLOCK_FRAMED_CUBE.value()).defaultBlockState(), IFramedBlock.createProperties(type));
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.SOLID, FramedProperties.GLOWING, FramedProperties.STATE_LOCKED, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = this.updateShapeLockable(state, level, currentPos, () -> super.updateShape(state, facing, facingState, level, currentPos, facingPos));
        if (newState == state) {
            this.updateCulling((LevelReader)level, currentPos);
        }
        return newState;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updateCulling((LevelReader)level, pos);
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos, null);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.empty();
        }
        return super.getShape(state, level, pos, ctx);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> lines, TooltipFlag flag) {
        this.appendCamoHoverText(stack, lines);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH);
    }

    @Override
    public Class<? extends Block> getJadeTargetClass() {
        return FramedStairsBlock.class;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH);
    }

    public static final class StairStateMerger
    implements StateMerger {
        private final StateMerger ignoringMerger = StateMerger.ignoring(WrapHelper.IGNORE_DEFAULT_LOCK);

        @Override
        public BlockState apply(BlockState state) {
            StairsShape shape = (StairsShape)(state = this.ignoringMerger.apply(state)).getValue((Property)StairBlock.SHAPE);
            if (shape == StairsShape.INNER_RIGHT) {
                state = (BlockState)((BlockState)state.setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.INNER_LEFT)).setValue((Property)StairBlock.FACING, (Comparable)((Direction)state.getValue((Property)StairBlock.FACING)).getClockWise());
            } else if (shape == StairsShape.OUTER_RIGHT) {
                state = (BlockState)((BlockState)state.setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.OUTER_LEFT)).setValue((Property)StairBlock.FACING, (Comparable)((Direction)state.getValue((Property)StairBlock.FACING)).getClockWise());
            }
            return state;
        }

        @Override
        public Set<Property<?>> getHandledProperties(Holder<Block> block) {
            return Utils.concat(this.ignoringMerger.getHandledProperties(block), Set.of(StairBlock.SHAPE));
        }
    }
}

