/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;

public class FramedChestBlockEntity
extends FramedStorageBlockEntity {
    public static final Component TITLE = Utils.translate("title", "framed_chest");
    private int openCount = 0;
    private long closeStart = 0L;
    private long lastChangeTime = 0L;
    private ChestState lastState = ChestState.CLOSED;

    public FramedChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_CHEST.value(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FramedChestBlockEntity tile) {
        if (!level.isClientSide() && level.getGameTime() - tile.closeStart >= 10L && state.getValue(PropertyHolder.CHEST_STATE) == ChestState.CLOSING) {
            tile.closeStart = 0L;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSED)));
        }
    }

    @Override
    public void open(ServerPlayer player) {
        if (this.getBlockState().getValue(PropertyHolder.CHEST_STATE) != ChestState.OPENING) {
            this.level().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.OPENING)));
            this.level().playSound(null, this.worldPosition, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, this.level().random.nextFloat() * 0.1f + 0.9f);
        }
        ++this.openCount;
        super.open(player);
    }

    public void close() {
        if (this.openCount > 0) {
            --this.openCount;
            if (this.openCount == 0) {
                this.level().playSound(null, this.worldPosition, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, this.level().random.nextFloat() * 0.1f + 0.9f);
                this.level().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSING)));
                this.closeStart = this.level().getGameTime();
            }
        }
    }

    public long getLastChangeTime(ChestState state) {
        if (this.lastChangeTime == 0L || state != this.lastState) {
            if (this.lastState == ChestState.CLOSING && state == ChestState.OPENING || this.lastState == ChestState.OPENING && state == ChestState.CLOSING) {
                long diff = this.level().getGameTime() - this.lastChangeTime;
                this.lastChangeTime = this.level().getGameTime() - (diff < 10L ? 10L - diff : 0L);
            } else {
                this.lastChangeTime = this.level().getGameTime();
            }
            this.lastState = state;
        }
        return this.lastChangeTime;
    }

    @Override
    protected Component getDefaultName() {
        return TITLE;
    }
}

