/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.blueprint.AuxBlueprintData;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.ICollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.component.CollapsibleBlockData;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public class FramedCollapsibleBlockEntity
extends FramedBlockEntity
implements ICollapsibleBlockEntity {
    public static final ModelProperty<Integer> OFFSETS = new ModelProperty();
    private static final int DIRECTIONS = Direction.values().length;
    private static final int VERTEX_COUNT = 4;
    private static final int BIT_PER_VERTEX = 5;
    private static final int VERTEX_MASK = 31;
    private static final NeighborVertex[][] VERTEX_MAPPINGS = FramedCollapsibleBlockEntity.makeVertexMapping();
    @Nullable
    private Direction collapsedFace = null;
    private int packedOffsets = 0;

    public FramedCollapsibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_COLLAPSIBLE_BLOCK.value(), pos, state);
    }

    public void handleDeform(Player player) {
        HitResult hit = player.pick(10.0, 1.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        Direction faceHit = blockHit.getDirection();
        Vec3 hitLoc = Utils.fraction(hit.getLocation());
        if (this.collapsedFace != null && faceHit != this.collapsedFace) {
            return;
        }
        int vert = FramedCollapsibleBlockEntity.vertexFromHit(faceHit, hitLoc);
        if (vert == 4) {
            for (int i = 0; i < 4; ++i) {
                this.handleDeformOfVertex(player, faceHit, i);
            }
        } else {
            this.handleDeformOfVertex(player, faceHit, vert);
        }
    }

    private void handleDeformOfVertex(Player player, Direction faceHit, int vert) {
        int offset = this.getVertexOffset(vert);
        if (player.isShiftKeyDown() && this.collapsedFace != null && offset > 0) {
            int target = offset - 1;
            this.applyDeformation(vert, target, faceHit);
            this.deformNeighbors(faceHit, vert, target);
        } else if (!player.isShiftKeyDown() && offset < 16) {
            int target = offset + 1;
            this.applyDeformation(vert, target, faceHit);
            this.deformNeighbors(faceHit, vert, target);
        }
    }

    private void applyDeformation(int vertex, int offset, Direction faceHit) {
        if ((offset = Mth.clamp((int)offset, (int)0, (int)16)) == this.getVertexOffset(vertex)) {
            return;
        }
        this.setVertexOffset(vertex, offset);
        if (offset == 0) {
            boolean noOffsets = true;
            for (int i = 0; i < 4; ++i) {
                if (this.getVertexOffset(i) <= 0) continue;
                noOffsets = false;
                break;
            }
            if (noOffsets) {
                this.collapsedFace = null;
                this.level().setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.NONE)), 3);
            } else {
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        } else if (this.collapsedFace == null) {
            this.collapsedFace = faceHit;
            this.level().setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.fromDirection(this.collapsedFace))), 3);
        } else {
            this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        this.setChangedWithoutSignalUpdate();
    }

    private void deformNeighbors(Direction faceHit, int srcVert, int offset) {
        NeighborVertex[] verts = VERTEX_MAPPINGS[FramedCollapsibleBlockEntity.getMappingIndex(faceHit, srcVert)];
        for (int i = 0; i < 3; ++i) {
            NeighborVertex vert = verts[i];
            BlockPos pos = this.worldPosition.offset(vert.offset);
            BlockEntity blockEntity = this.level().getBlockEntity(pos);
            if (!(blockEntity instanceof FramedCollapsibleBlockEntity)) continue;
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            if (be.collapsedFace != null && be.collapsedFace != faceHit) continue;
            be.applyDeformation(vert.targetVert, offset, faceHit);
        }
    }

    private void setVertexOffset(int vertex, int offset) {
        int idx = vertex * 5;
        int mask = 31 << idx;
        this.packedOffsets = this.packedOffsets & ~mask | offset << idx;
    }

    public static int vertexFromHit(Direction faceHit, Vec3 loc) {
        boolean positive;
        if (Utils.isY(faceHit)) {
            double ax = Math.abs((loc.x - 0.5) * 4.0);
            double az = Math.abs((loc.z - 0.5) * 4.0);
            if (ax >= 0.0 && ax <= 1.0 && az >= 0.0 && az <= 1.0 && az <= 1.0 - ax) {
                return 4;
            }
            if (loc.z < 0.5 == (faceHit == Direction.UP)) {
                return loc.x < 0.5 ? 0 : 3;
            }
            return loc.x < 0.5 ? 1 : 2;
        }
        double xz = Utils.isX(faceHit) ? loc.z : loc.x;
        double axz = Math.abs((xz - 0.5) * 4.0);
        double ay = Math.abs((loc.y - 0.5) * 4.0);
        if (axz >= 0.0 && axz <= 1.0 && ay >= 0.0 && ay <= 1.0 && ay <= 1.0 - axz) {
            return 4;
        }
        boolean bl = positive = faceHit == Direction.SOUTH || faceHit == Direction.WEST;
        if (loc.y < 0.5) {
            return xz < 0.5 == positive ? 1 : 2;
        }
        return xz < 0.5 == positive ? 0 : 3;
    }

    @Nullable
    public Direction getCollapsedFace() {
        return this.collapsedFace;
    }

    public int getVertexOffset(int vertex) {
        return this.packedOffsets >> vertex * 5 & 0x1F;
    }

    @Override
    public int getVertexOffset(BlockState state, int vertex) {
        return this.getVertexOffset(vertex);
    }

    @Override
    public int getPackedOffsets(BlockState state) {
        return this.packedOffsets;
    }

    @Override
    protected void attachAdditionalModelData(ModelData.Builder builder) {
        builder.with(OFFSETS, (Object)this.packedOffsets);
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(nbt, lookupProvider);
        nbt.putInt("offsets", this.packedOffsets);
        nbt.putByte("face", (byte)(this.collapsedFace == null ? -1 : this.collapsedFace.get3DDataValue()));
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        byte faceIdx;
        Direction face;
        boolean needUpdate = super.readFromDataPacket(nbt, lookupProvider);
        int packed = nbt.getInt("offsets");
        if (packed != this.packedOffsets) {
            this.packedOffsets = packed;
            needUpdate = true;
            this.updateCulling(true, false);
        }
        Direction direction = face = (faceIdx = nbt.getByte("face")) == -1 ? null : Direction.from3DDataValue((int)faceIdx);
        if (this.collapsedFace != face) {
            this.collapsedFace = face;
            needUpdate = true;
        }
        return needUpdate;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.putInt("offsets", this.packedOffsets);
        nbt.putByte("face", (byte)(this.collapsedFace == null ? -1 : this.collapsedFace.get3DDataValue()));
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        this.packedOffsets = nbt.getInt("offsets");
        byte face = nbt.getByte("face");
        this.collapsedFace = face == -1 ? null : Direction.from3DDataValue((int)face);
        super.handleUpdateTag(nbt, provider);
    }

    @Override
    protected Optional<AuxBlueprintData<?>> collectAuxBlueprintData() {
        return Optional.of(new CollapsibleBlockData(this.collapsedFace, this.packedOffsets));
    }

    @Override
    protected void applyAuxDataFromBlueprint(AuxBlueprintData<?> auxData) {
        if (auxData instanceof CollapsibleBlockData) {
            CollapsibleBlockData blockData = (CollapsibleBlockData)auxData;
            this.collapsedFace = blockData.collapsedFace().toDirection();
            this.packedOffsets = blockData.offsets();
        }
    }

    @Override
    protected void collectMiscComponents(DataComponentMap.Builder builder) {
        builder.set(FBContent.DC_TYPE_COLLAPSIBLE_BLOCK_DATA, (Object)new CollapsibleBlockData(this.collapsedFace, this.packedOffsets));
    }

    @Override
    protected void applyMiscComponents(BlockEntity.DataComponentInput input) {
        CollapsibleBlockData blockData = (CollapsibleBlockData)input.get(FBContent.DC_TYPE_COLLAPSIBLE_BLOCK_DATA);
        if (blockData != null) {
            this.collapsedFace = blockData.collapsedFace().toDirection();
            this.packedOffsets = blockData.offsets();
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putInt("offsets", this.packedOffsets);
        nbt.putInt("face", this.collapsedFace == null ? -1 : this.collapsedFace.get3DDataValue());
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.packedOffsets = nbt.getInt("offsets");
        int face = nbt.getInt("face");
        this.collapsedFace = face == -1 ? null : Direction.from3DDataValue((int)face);
    }

    public static byte[] unpackOffsets(int packed) {
        byte[] offsets = new byte[4];
        for (int i = 0; i < 4; ++i) {
            offsets[i] = (byte)(packed >> i * 5 & 0x1F);
        }
        return offsets;
    }

    private static int getMappingIndex(Direction face, int srcVert) {
        return face.ordinal() * 4 + srcVert;
    }

    private static NeighborVertex[][] makeVertexMapping() {
        NeighborVertex[][] mappings = new NeighborVertex[DIRECTIONS * 4][];
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.UP, 0, new NeighborVertex(new Vec3i(-1, 0, 0), 3), new NeighborVertex(new Vec3i(0, 0, -1), 1), new NeighborVertex(new Vec3i(-1, 0, -1), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.UP, 1, new NeighborVertex(new Vec3i(-1, 0, 0), 2), new NeighborVertex(new Vec3i(0, 0, 1), 0), new NeighborVertex(new Vec3i(-1, 0, 1), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.UP, 2, new NeighborVertex(new Vec3i(1, 0, 0), 1), new NeighborVertex(new Vec3i(0, 0, 1), 3), new NeighborVertex(new Vec3i(1, 0, 1), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.UP, 3, new NeighborVertex(new Vec3i(1, 0, 0), 0), new NeighborVertex(new Vec3i(0, 0, -1), 2), new NeighborVertex(new Vec3i(1, 0, -1), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.DOWN, 0, new NeighborVertex(new Vec3i(-1, 0, 0), 3), new NeighborVertex(new Vec3i(0, 0, 1), 1), new NeighborVertex(new Vec3i(-1, 0, 1), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.DOWN, 1, new NeighborVertex(new Vec3i(-1, 0, 0), 2), new NeighborVertex(new Vec3i(0, 0, -1), 0), new NeighborVertex(new Vec3i(-1, 0, -1), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.DOWN, 2, new NeighborVertex(new Vec3i(1, 0, 0), 1), new NeighborVertex(new Vec3i(0, 0, -1), 3), new NeighborVertex(new Vec3i(1, 0, -1), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.DOWN, 3, new NeighborVertex(new Vec3i(1, 0, 0), 0), new NeighborVertex(new Vec3i(0, 0, 1), 2), new NeighborVertex(new Vec3i(1, 0, 1), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.NORTH, 0, new NeighborVertex(new Vec3i(1, 0, 0), 3), new NeighborVertex(new Vec3i(0, 1, 0), 1), new NeighborVertex(new Vec3i(1, 1, 0), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.NORTH, 1, new NeighborVertex(new Vec3i(1, 0, 0), 2), new NeighborVertex(new Vec3i(0, -1, 0), 0), new NeighborVertex(new Vec3i(1, -1, 0), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.NORTH, 2, new NeighborVertex(new Vec3i(-1, 0, 0), 1), new NeighborVertex(new Vec3i(0, -1, 0), 3), new NeighborVertex(new Vec3i(-1, -1, 0), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.NORTH, 3, new NeighborVertex(new Vec3i(-1, 0, 0), 0), new NeighborVertex(new Vec3i(0, 1, 0), 2), new NeighborVertex(new Vec3i(-1, 1, 0), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.SOUTH, 0, new NeighborVertex(new Vec3i(-1, 0, 0), 3), new NeighborVertex(new Vec3i(0, 1, 0), 1), new NeighborVertex(new Vec3i(-1, 1, 0), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.SOUTH, 1, new NeighborVertex(new Vec3i(-1, 0, 0), 2), new NeighborVertex(new Vec3i(0, -1, 0), 0), new NeighborVertex(new Vec3i(-1, -1, 0), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.SOUTH, 2, new NeighborVertex(new Vec3i(1, 0, 0), 1), new NeighborVertex(new Vec3i(0, -1, 0), 3), new NeighborVertex(new Vec3i(1, -1, 0), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.SOUTH, 3, new NeighborVertex(new Vec3i(1, 0, 0), 0), new NeighborVertex(new Vec3i(0, 1, 0), 2), new NeighborVertex(new Vec3i(1, 1, 0), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.EAST, 0, new NeighborVertex(new Vec3i(0, 0, 1), 3), new NeighborVertex(new Vec3i(0, 1, 0), 1), new NeighborVertex(new Vec3i(0, 1, 1), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.EAST, 1, new NeighborVertex(new Vec3i(0, 0, 1), 2), new NeighborVertex(new Vec3i(0, -1, 0), 0), new NeighborVertex(new Vec3i(0, -1, 1), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.EAST, 2, new NeighborVertex(new Vec3i(0, 0, -1), 1), new NeighborVertex(new Vec3i(0, -1, 0), 3), new NeighborVertex(new Vec3i(0, -1, -1), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.EAST, 3, new NeighborVertex(new Vec3i(0, 0, -1), 0), new NeighborVertex(new Vec3i(0, 1, 0), 2), new NeighborVertex(new Vec3i(0, 1, -1), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.WEST, 0, new NeighborVertex(new Vec3i(0, 0, -1), 3), new NeighborVertex(new Vec3i(0, 1, 0), 1), new NeighborVertex(new Vec3i(0, 1, -1), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.WEST, 1, new NeighborVertex(new Vec3i(0, 0, -1), 2), new NeighborVertex(new Vec3i(0, -1, 0), 0), new NeighborVertex(new Vec3i(0, -1, -1), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.WEST, 2, new NeighborVertex(new Vec3i(0, 0, 1), 1), new NeighborVertex(new Vec3i(0, -1, 0), 3), new NeighborVertex(new Vec3i(0, -1, 1), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.WEST, 3, new NeighborVertex(new Vec3i(0, 0, 1), 0), new NeighborVertex(new Vec3i(0, 1, 0), 2), new NeighborVertex(new Vec3i(0, 1, 1), 1));
        return mappings;
    }

    private static void putMapping(NeighborVertex[][] mappings, Direction face, int srcVert, NeighborVertex vertOne, NeighborVertex vertTwo, NeighborVertex vertBoth) {
        mappings[FramedCollapsibleBlockEntity.getMappingIndex((Direction)face, (int)srcVert)] = new NeighborVertex[]{vertOne, vertTwo, vertBoth};
    }

    private record NeighborVertex(Vec3i offset, int targetVert) {
    }
}

